<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;

class AdmissionTemplateExport implements FromArray, WithHeadings, WithTitle
{
    /**
     * @return array
     */
    public function array(): array
    {
        // Sample data rows for the template
        return [
            [
                'R0/00000', // army_number
                'Mwanika Hudson', // name
                'O/CDT', // rank
                'freemanhudson3@gmail.com', // email
                '0708079019', // phone_number
                12, // school_id
                27, // course_id
                1, // intake_id
                'kagera', // bn
                'A', // coy
                '1', // pl
                'I', // sec
                'Nakaseke', // home_district
                'Nsereko Zone', // village
                'Next Kin Name', // next_kin
                '0752222222', // next_kin_phone
                'Relationship', // next_kin_rel
                'M', // sex
                'CM920691000PDC', // nin
                'Father Name', // father_name
                '0750000000', // father_phone
                'Mother Name', // mother_name
                '0751111111', // mother_phone
                'UCE', // education_level
                'Spouse Name', // spouse_name
                '0753333333', // spouse_phone
                11, // shoe_size
                2025, // year_admission
            ],
        ];
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'army_number',
            'name', 
            'rank',
            'email',
            'phone_number',
            'school_id',
            'course_id',
            'intake_id',
            'bn',
            'coy', 
            'pl',
            'sec',
            'home_district',
            'village',
            'next_kin',
            'next_kin_phone',
            'next_kin_rel',
            'sex',
            'nin',
            'father_name',
            'father_phone',
            'mother_name',
            'mother_phone',
            'education_level',
            'spouse_name',
            'spouse_phone',
            'shoe_size',
            'year_admission',
        ];
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'Admissions Template';
    }
}