<?php

namespace App\Exports;

use App\Models\Assessment;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class MarksExport implements FromCollection, WithHeadings
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $query = Assessment::with(['admission'])
            ->whereHas('admission', function ($q) {
                $q->whereNull('deleted_at');
            });

        // Filters
        foreach (['assessment_type', 'assessment_group', 'type', 'subject_id', 'month', 'week', 'bn', 'coy'] as $filter) {
            if (!empty($this->request[$filter])) {
                $query->where($filter, $this->request[$filter]);
            }
        }

        if (!empty($this->request['search'])) {
            $search = $this->request['search'];
            $query->whereHas('admission', function ($q) use ($search) {
                $q->where('name', 'like', "%$search%")
                  ->orWhere('army_number', 'like', "%$search%")
                  ->orWhere('rank', 'like', "%$search%");
            });
        }

        $query->orderBy('marks', 'desc');

        // Fetch & transform
        return $query->get()->map(function ($assessment) {
            return [
                'Army Number' => $assessment->admission->army_number ?? '',
                'Rank' => $assessment->admission->rank ?? '',
                'Name' => $assessment->admission->name ?? '',
                'Exercises  ' => $assessment->exercises ?? '',
                'Subject' =>  '',
                'Week' => $assessment->week ?? '', // Add this line
                'Marks (%)' => number_format($assessment->marks, 1) . '%',
                'Month' => $assessment->month ?? '',
            ];
        });
    }

    public function headings(): array
    {
        return ['Army Number', 'Rank', 'Name', 'Exercises', 'Subject', 'Week', 'Marks (%)', 'Month']; // Add 'Week' here
    }
}