<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\ActivityLog;
use Illuminate\Http\Request;

class ActivityLogController extends Controller
{
  


        public function index(Request $request)
{
    $query = ActivityLog::query()->latest();

    if ($request->filled('action')) {
        $query->where('action', $request->action);
    }

    if ($request->filled('date_from')) {
        $query->whereDate('created_at', '>=', $request->date_from);
    }

    if ($request->filled('date_to')) {
        $query->whereDate('created_at', '<=', $request->date_to);
    }

    $logs = $query->paginate(25);

    return view('logs.index', compact('logs'));
}
    
    }
    

