<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function loginIndex()
    {
        return view('login');
    }

    public function registerIndex()
    {
        return view('register');
    }

    public function login(Request $request)
    {
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required|min:8',
        ]);

        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            return redirect('dashboard');
        }

        toastr()->error('Invalid email or password');
        return redirect('login');
    }

// sso login is handled by SsoController, so we don't need the normal login method here. We can keep it commented out for reference, but it won't be used in the current SSO-based authentication flow.
    // public function login(Request $request)
    // {
    //     $request->validate([
    //         'email' => 'required|email',
    //         'password' => 'required|min:6',
    //     ]);

    //     $credentials = $request->only('email', 'password');
        
    //     if (Auth::attempt($credentials, $request->has('remember'))) {
    //         $user = Auth::user();
    //         User::logLogin($user); // Log successful login
    //         return redirect()->intended('dashboard')->with('status', 'Login successful!');
    //     }

    //     return back()->withErrors(['email' => 'Invalid credentials.'])->withInput($request->only('email'));
    // }


    public function register(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required|min:8',
        ]);

        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = \Hash::make($request->password);
        $user->save();

        Auth::login($user);
        User::logLogin($user); // Log successful registration and login
        toastr()->success('Registration successful!');
        return redirect('dashboard');
    }

    public function logout()
    {
        if (Auth::check()) {
            $user = Auth::user();
            User::logLogout($user); // Log logout
            Auth::logout();
            toastr()->success('Logout successful!');
        }
        return redirect('/');
    }
}
