<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Bn;
use App\Models\Coy;
use App\Models\Pl;
use App\Models\Sec;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class BnController extends Controller
{
    public function index()
    {
        try {
            $bn = Bn::all();
            $coy = Coy::all();
            $pl = Pl::all();
            $sec = Sec::all();
        } catch (\Exception $e) {
            Log::error('Error fetching data: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to fetch data.');
        }
        return view('bn.index', compact('bn', 'coy', 'pl', 'sec'));
    }

    public function create()
    {
        return view('bn.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'comd_name' => 'nullable|string|max:255',
            'comd_rank' => 'nullable|string|max:255',
            'comd_initials' => 'nullable|string|max:255',
        ]);

        DB::beginTransaction();
        try {
            Bn::create($validated);
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Bn created successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error creating Bn: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to create Bn.');
        }
    }

    public function edit(Bn $bn)
    {
        return view('bn.edit', compact('bn'));
    }

    public function update(Request $request, Bn $bn)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'comd_name' => 'nullable|string|max:255',
            'comd_rank' => 'nullable|string|max:255',
            'comd_initials' => 'nullable|string|max:255',
        ]);

        DB::beginTransaction();
        try {
            $bn->update($validated);
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Bn updated successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error updating Bn: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to update Bn.');
        }
    }

    public function destroy(Bn $bn)
    {
        DB::beginTransaction();
        try {
            $bn->delete();
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Bn deleted successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error deleting Bn: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to delete Bn.');
        }
    }
}
