<?php

namespace App\Http\Controllers;

use App\Models\Course;
use App\Models\School;
use Illuminate\Http\Request;

class CourseController extends Controller
{
    public function index()
    {
        $courses = Course::with('school')->get();
        return view('courses.index', compact('courses'));
    }

    public function create()
    {
        $schools = School::all();
        return view('courses.create', compact('schools'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'school_id' => 'required|exists:schools,id',
        ]);

        try {
            Course::create($validated);
            return redirect()->route('courses.index')
                ->with('success', 'Course created successfully');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Failed to create course')
                ->withInput();
        }
    }

    public function edit(Course $course)
    {
        $schools = School::all();
        return view('courses.edit', compact('course', 'schools'));
    }

    public function update(Request $request, Course $course)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'school_id' => 'required|exists:schools,id',
        ]);

        try {
            $course->update($validated);
            return redirect()->route('courses.index')
                ->with('success', 'Course updated successfully');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Failed to update course')
                ->withInput();
        }
    }

    public function destroy(Course $course)
    {
        try {
            $course->delete();
            return redirect()->route('courses.index')
                ->with('success', 'Course deleted successfully');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Failed to delete course');
        }
    }
}