<?php

namespace App\Http\Controllers;

use App\Models\Bn;
use App\Models\Coy;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class CoyController extends Controller
{
    public function index()
    {
        try {
            $coy = Coy::all();
        } catch (\Exception $e) {
            Log::error('Error fetching companies: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to fetch companies.');
        }
        return view('bn.index', compact('coy'));
    }

    public function create()
    {
        try {
            $bns = Bn::all();
        } catch (\Exception $e) {
            Log::error('Error fetching battalions: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to fetch battalions.');
        }
        return view('coy.create', compact('bns'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'bn_id' => 'required|exists:bns,id',
            'comd_name' => 'nullable|string|max:255',
            'comd_rank' => 'nullable|string|max:255',
            'comd_initials' => 'nullable|string|max:255',
        ]);

        DB::beginTransaction();
        try {
            Coy::create($validated);
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Coy created successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error creating company: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to create company.');
        }
    }

    public function edit(Coy $coy)
    {
        try {
            $bns = Bn::all();
        } catch (\Exception $e) {
            Log::error('Error fetching battalions: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to fetch battalions.');
        }
        return view('coy.edit', compact('coy', 'bns'));
    }

    public function update(Request $request, Coy $coy)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'bn_id' => 'required|exists:bns,id',
            'comd_name' => 'nullable|string|max:255',
            'comd_rank' => 'nullable|string|max:255',
            'comd_initials' => 'nullable|string|max:255',
        ]);

        DB::beginTransaction();
        try {
            $coy->update($validated);
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Coy updated successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error updating company: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to update company.');
        }
    }

    public function destroy(Coy $coy)
    {
        DB::beginTransaction();
        try {
            $coy->delete();
            DB::commit();
            return redirect()->route('bn.index')->with('success', 'Coy deleted successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error deleting company: ' . $e->getMessage());
            return redirect()->route('bn.index')->with('error', 'Failed to delete company.');
        }
    }
}
