<?php

namespace App\Http\Controllers;

use App\Models\Phase;
use Illuminate\Http\Request;
use App\Models\ExamWeight;

class ExamWeightController extends Controller
{

    public function index()
    {
        $records = ExamWeight::all();
        return view('exercise.index', compact('records'));
    }

    public function create()
    {

        $phases  = Phase::all();
        return view('examweight.create', compact('phases'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'weight' => 'required|numeric',
            'phase_id' => 'required|string|max:255'

        ]);

        ExamWeight::create($validated);

        return redirect()->route('exercise.index')
            ->with('success', 'Record created successfully');
    }

    public function edit($id)
    {
        $record = ExamWeight::findOrFail($id);

        $phases = Phase::pluck('name', 'id');

        return view('examweight.edit', compact('record', 'phases'));
    }

    public function update(Request $request, $id)
    {
        // Find the record first
        $record = ExamWeight::findOrFail($id);



        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'weight' => 'required|numeric|min:0|max:100',
            'phase_id' => 'required|string|max:255'
        ]);

        try {
            $record->update($validated);
            return redirect()->route('wss')
                ->with('success', 'Record updated successfully');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Failed to update record: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function destroy(ExamWeight $record)
    {
        $record->delete();

        return redirect()->route('exercise.index')
            ->with('success', 'Record deleted successfully');
    }
}
