<?php

namespace App\Http\Controllers;

use App\Models\Phase;
use Illuminate\Http\Request;
use App\Models\Exercise;
use App\Models\ExamWeight;

class ExerciseController extends Controller
{

    public function index()
    {
        $exercises = Exercise::all();
        $examweights = ExamWeight::all();
        return view('exercise.index', compact('exercises','examweights'));
    }

    public function create()
    {

        $phases = Phase::all();
        return view('exercise.create',compact('phases'));
    }

    public function store(Request $request)
    {


        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'weight' => 'required|numeric',
            'phase_id' => 'required|string|max:255'

        ]);

       Exercise::create($validated);

        return redirect()->route('wss')
            ->with('success', 'Record created successfully');
    }

    public function edit($id)
    {


        $record = Exercise::findOrFail($id);
        $phases = Phase::pluck('name', 'id'); // Plucking 'id' as the value and 'name' as the label
        return view('exercise.edit', compact('record', 'phases'));
    }


    public function update(Request $request, $id)
    {
        // Find the record first
        $record = Exercise::findOrFail($id);

        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'weight' => 'required|numeric|min:0|max:100',
            'phase_id' => 'required|string|max:255'
        ]);

        try {
            $record->update($validated);
            return redirect()->route('wss')
                ->with('success', 'Record updated successfully');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Failed to update record: ' . $e->getMessage())
                ->withInput();
        }
    }

    public function destroy(Exercise $record)
    {
        $record->delete();

        return redirect()->route('wss')
            ->with('success', 'Record deleted successfully');
    }
}
