<?php

namespace App\Http\Controllers;


use App\Models\School;
use App\Models\Course;
use App\Models\Intake;
use Illuminate\Http\Request;
use App\Models\Phase;
use App\Models\Exercise;
use App\Models\ExamWeight;
use Illuminate\Support\Facades\Auth;

class SchoolController extends Controller
{


    public function wss()
    {
        $phases = Phase::all();
        $exercises = Exercise::all();
        $examWeight = ExamWeight::all();

        return view('wss', compact('phases','exercises','examWeight'));
    }

    public function index()
    {
        $schools = School::all();
        $courses = Course::all();
        $intakes = Intake::all();
          // Check if Phase 3 is currently running (is_active = 1)
        
        

          $phase = Phase::find(3)->first();
$isPhase3Running = $phase && $phase->is_active;
$canCreateIntake = !$isPhase3Running;


          
          



        return view('schools.index', compact('schools','courses','intakes', 'canCreateIntake'));
    }

    public function create()
    {
        return view('schools.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
           
        ]);

        School::create($request->all());

        return redirect()->route('schools.index')->with('success', 'School created successfully.');
    }

    public function edit(School $school)
    {
        return view('schools.edit', compact('school'));
    }

    public function update(Request $request, School $school)
    {
        $request->validate([
            'name' => 'required|string|max:255',
     
        ]);

        $school->update($request->all());

        return redirect()->route('schools.index')->with('success', 'School updated successfully.');
    }

    public function destroy(School $school)
    {
        $school->delete();

        return redirect()->route('schools.index')->with('success', 'School deleted successfully.');
    }
}
