<?php

namespace App\Http\Controllers;
use App\Models\TwentyTwoCR;
use Illuminate\Http\Request;
use App\Models\Phase;

class TwentyTwoCRController extends Controller
{

    public function index(Request $request)
    {
   $query = TwentyTwoCr::query();

    if ($request->filled('phase')) {
        $query->where('phase', $request->phase);
    }

    $records = $query->get();
    $phases = Phase::all(); // or whatever you're using to manage phase names

        return view('22cr.index', compact('records','phases'));

        
    }

    public function create()
    {

        $phases = Phase::all();

        return view('22cr.create', compact('phases'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'weight' => 'required|numeric',
            'phase' => 'required|string|max:255'
        ]);

        TwentyTwoCR::create($validated);

        return redirect()->route('twenty_two_cr.index')
            ->with('success', 'Record created successfully');
    }

    public function edit($id)
    {
        $record = TwentyTwoCr::findOrFail($id);

         $phases = Phase::all();
        return view('22cr.edit', compact('record', 'phases'));
    }
    
    public function update(Request $request, TwentyTwoCR $record)
    {


        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'weight' => 'required|numeric',
            'phase' => 'required|string|max:255'
        ]);

        $record->update($validated);

        return redirect()->route('twenty_two_cr.index')
            ->with('success', 'Record updated successfully');
    }

    public function destroy(TwentyTwoCR $record)
    {
        $record->delete();

        return redirect()->route('twenty_two_cr.index')
            ->with('success', 'Record deleted successfully');
    }
}
