<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
class Bn extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $fillable = [
        'comd_name',   // Name of the Company Commander
        'comd_rank',
        'comd_initials',
        'name',];

    // One-to-Many relationship: A Bn can have many Coys
    public function coys()
    {
        return $this->hasMany(Coy::class);
    }


    // Many-to-Many relationship: Bn can have multiple Pls
    public function pls(): BelongsToMany
    {
        return $this->belongsToMany(Pl::class, 'bn_pl', 'bn_id', 'pl_id');
    }
}
