<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BnCoyPlSec extends Model
{
    protected $table = 'bn_coy_pl_sec';

    protected $fillable = [
        'bn_id',
        'coy_id',
        'pl_id',
        'sec_id',
    ];

    // Define relationships
    public function bn()
    {
        return $this->belongsTo(Bn::class);
    }

    public function coy()
    {
        return $this->belongsTo(Coy::class);
    }

    public function pl()
    {
        return $this->belongsTo(Pl::class);
    }

    public function sec()
    {
        return $this->belongsTo(Sec::class);
    }
}
