<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
class Coy extends Model
{
    use HasFactory;
    use LogsActivity;
    protected $fillable = [
        'name',  // Name of the Company
        'comd_name',   // Name of the Company Commander
        'comd_rank',
        'comd_initials',
        'bn_id'
    ];

    public function bn(): BelongsTo
    {
        return $this->belongsTo(Bn::class);
    }
    public function pls()
    {
        return $this->hasMany(Pl::class);
    }
    public function secs(): HasMany
    {
        return $this->hasMany(Sec::class);
    }



}
