<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GpvReportDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'gpv_report_id',
        'admission_id',
        'admission_number',
        'army_number',
        'rank',
        'name',
        'school',
        'course',
        'theory_score',
        'practical_score',
        'cr_22_score',
        'pr_score',
        'total_score',
        'grade',
        'comment',
        'remarks'
    ];

    public function gpvReport()
    {
        return $this->belongsTo(GpvReport::class);
    }

    public function admission()
    {
        return $this->belongsTo(Admission::class);
    }
}
