<?php

// app/Models/Remark.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;

class Remark extends Model
{
    use HasFactory, LogsActivity;

    protected $fillable = [
        'admission_id',
        'phase',
        'pl_comd_remarks',
        'oc_remarks',
        'ci_remarks',
        'comdt_remarks',
        'student_remarks',
        'pl_comd_signature',
        'oc_signature',
        'ci_signature',
        'comdt_signature',
        'student_signature',
    ];

    public function admission()
    {
        return $this->belongsTo(Admission::class);
    }
}
