<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;

class RemarkTemplate extends Model
{

    use LogsActivity;
    protected $fillable = [
        'phase_id',
        'grade',
        'type',
        'remark_text'
    ];

    // Relationships
    public function phase()
    {
        return $this->belongsTo(Phase::class);
    }

    // Validation rules
    public static function rules($id = null)
    {
        return [
            'phase_id' => 'required|exists:phases,id',
            'grade' => 'required|in:A,B,C,D,E,F',
            'type' => 'required|in:CI,COMDT,PL_COMD,OC',
            'remark_text' => 'required|string|min:10',
        ];
    }
}