<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Staff extends Model
{
    protected $fillable = ['name', 'school_id', 'group_id'];

    // A staff member belongs to a school
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    // A staff member belongs to a group
    public function group()
    {
        return $this->belongsTo(Group::class);
    }
}
