<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivity;
class Student extends Model
{
    use LogsActivity;

    protected $fillable = [
        'name',
        'army_number',
        'rank',

        'status',      // Add new fields here
        'sex',         // Add new fields here
        'mil_id_no',   // Add new fields here
        'is_ugandan',  // Add new fields here
    ];

    public function subjects()
    {
        return $this->belongsToMany(Subject::class, 'subject_student');
    }
    public function scores() {
        return $this->hasMany(StudentScore::class);
    }

    public function finalGrades() {
        return $this->hasMany(FinalGrade::class);
    }
    public function school()
    {
        return $this->belongsTo(School::class, 'school_id'); // Ensure 'School' model exists
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id'); // Ensure 'Course' model exists
    }

    public function intake()
    {
        return $this->belongsTo(Intake::class, 'intake_id'); // Ensure 'Intake' model exists
    }




public function assessments()
{
    return $this->hasMany(Assessment::class, 'admission_id');
}

public function admissions()
{
    return $this->belongsToMany(Admission::class, 'admission_subject', 'subject_id', 'admission_id');
}

public function calculateWeightedScore()
{
    $assessments = $this->assessments; // Get all assessments for this cadet
    $totalScore = 0;

    foreach ($assessments as $assessment) {
        $weightedScore = ($assessment->marks / 100) * $assessment->weight;
        $totalScore += $weightedScore;
    }

    return $totalScore; // Return the total weighted score
}

}
