<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentPerformance extends Model
{
    use HasFactory;

    protected $fillable = [
        'army_number',
        'name',
        'msk_theory',
        'msk_practical',
        'character_assessment_22cr',
        'character_assessment_pr'
    ];

    public function calculateTotal()
    {
        return $this->msk_theory + 
               $this->msk_practical + 
               $this->character_assessment_22cr + 
               $this->character_assessment_pr;
    }

    public function calculateGrade()
    {
        $total = $this->calculateTotal();
        
        if ($total >= 80) return 'A';
        if ($total >= 70) return 'B';
        if ($total >= 60) return 'C';
        if ($total >= 50) return 'D';
        return 'F';
    }

    public function isPassed()
    {
        return $this->calculateTotal() >= 50;
    }
}
