<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Traits\LogsActivity;

class Subject extends Model
{
    use LogsActivity;

    protected $fillable = ['name', 'code', 'weight', 'school_id', 'course_id', 'phase_id', 'description'];

    public function assessments()
    {
        return $this->hasMany(Assessment::class, 'subject_id');
    }

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function phase()
    {
        return $this->belongsTo(Phase::class);
    }

    public function courses()
    {
        return $this->belongsToMany(Course::class, 'course_subject');
    }
}