<?php

namespace App\Observers;

use Illuminate\Support\Facades\Cache;

class AssessmentObserver
{
    public function created($assessment)
    {
        $this->clearCache();
    }

    public function updated($assessment)
    {
        $this->clearCache();
    }

    public function deleted($assessment)
    {
        $this->clearCache();
    }

    private function clearCache()
    {
        // Option 1: Clear specific cache keys instead of using Redis-specific methods
        $cacheKeys = [
            'filtered_students',
            'assessment_data',
            'marks_data',
            // Add any other specific cache keys you're using
        ];

        foreach ($cacheKeys as $key) {
            Cache::forget($key);
        }

        // Option 2: Clear all cache (be careful with this in production)
        // Cache::flush();

        // Option 3: If you need to clear cache with patterns, use this approach
        // This works with any cache driver, not just Redis
        try {
            // Only use Redis-specific commands if Redis is actually configured
            if (config('cache.default') === 'redis') {
                $redis = Cache::getStore()->getRedis();
                $keys = $redis->keys('*assessment*');
                if (!empty($keys)) {
                    $redis->del($keys);
                }
            } else {
                // For file/database cache, just clear specific keys
                Cache::forget('assessment_cache');
                Cache::flush(); // Use with caution in production
            }
        } catch (\Exception $e) {
            // Log the error but don't break the application
            \Log::warning('Cache clearing failed: ' . $e->getMessage());
        }
    }
}