<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAssessmentFieldsToAssessmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('assessments', function (Blueprint $table) {
          // F fields
          $table->decimal('f1', 8, 2)->nullable();
          $table->decimal('f2', 8, 2)->nullable();
          $table->decimal('f3', 8, 2)->nullable();
          $table->decimal('f4', 8, 2)->nullable();
          $table->decimal('f5', 8, 2)->nullable();
          
          // FX fields
          $table->decimal('fx1', 8, 2)->nullable();
          $table->decimal('fx2', 8, 2)->nullable();
          $table->decimal('fx3', 8, 2)->nullable();
          $table->decimal('fx4', 8, 2)->nullable();
          $table->decimal('fx5', 8, 2)->nullable();
          
          // Sum fields
          $table->decimal('sum_f', 10, 2);
          $table->decimal('sum_fx', 10, 2);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('assessments', function (Blueprint $table) {
            // Drop F fields
            $table->dropColumn('f1');
            $table->dropColumn('f2');
            $table->dropColumn('f3');
            $table->dropColumn('f4');
            $table->dropColumn('f5');
            
            // Drop FX fields
            $table->dropColumn('fx1');
            $table->dropColumn('fx2');
            $table->dropColumn('fx3');
            $table->dropColumn('fx4');
            $table->dropColumn('fx5');
            
            // Drop sum fields
            $table->dropColumn('sum_f');
            $table->dropColumn('sum_fx');
        });
    }
}
