<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCRAssessmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('c_r_assessments', function (Blueprint $table) {
            $table->id();
            $table->string('army_number');
            $table->string('name');
            $table->foreignId('school_id')->constrained('schools');
            $table->foreignId('course_id')->constrained('courses');
            $table->foreignId('intake_id')->constrained('intakes');
            $table->string('phase')->default('Phase 1');
            $table->string('assessment_type')->default('Character Assessment');
            $table->string('assessment_group')->default('22 CR');
            $table->decimal('total_cres', 8, 2)->default(0.00);
            $table->decimal('percentage_score', 8, 2)->default(0.00);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('c_r_assessments');
    }
}
