<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddExercisesToUniqueConstraintInAssessments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('assessments', function (Blueprint $table) {
            // First drop the existing unique constraint
            $table->dropUnique('unique_assessment_index');
            
            // Then create a new one that includes exercises
            $table->unique([
                'admission_id', 
                'assessment_type', 
                'assessment_group', 
                'type', 
                'phase', 
                'subject_id', 
                'week',
                'exercises'
            ], 'unique_assessment_index');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('assessments', function (Blueprint $table) {
            // First drop the new constraint
            $table->dropUnique('unique_assessment_index');
            
            // Then recreate the original one without exercises
            $table->unique([
                'admission_id', 
                'assessment_type', 
                'assessment_group', 
                'type', 
                'phase', 
                'subject_id', 
                'week'
            ], 'unique_assessment_index');
        });
    }
}