<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // First, remove any existing duplicates
        DB::statement("
            DELETE a1 FROM assessments a1
            INNER JOIN assessments a2 
            WHERE 
                a1.id > a2.id
                AND a1.admission_id = a2.admission_id
                AND a1.phase = a2.phase
                AND a1.assessment_type = a2.assessment_type
                AND a1.assessment_group = a2.assessment_group
                AND a1.type = a2.type
                AND (a1.subject_id = a2.subject_id OR (a1.subject_id IS NULL AND a2.subject_id IS NULL))
                AND (a1.week = a2.week OR (a1.week IS NULL AND a2.week IS NULL))
                AND (a1.month = a2.month OR (a1.month IS NULL AND a2.month IS NULL))
                AND (a1.bn = a2.bn OR (a1.bn IS NULL AND a2.bn IS NULL))
                AND (a1.coy = a2.coy OR (a1.coy IS NULL AND a2.coy IS NULL))
                AND (a1.pl = a2.pl OR (a1.pl IS NULL AND a2.pl IS NULL))
                AND (a1.sec = a2.sec OR (a1.sec IS NULL AND a2.sec IS NULL))
        ");

        // Add unique index
        Schema::table('assessments', function (Blueprint $table) {
            $table->unique([
                'admission_id',
                'phase',
                'assessment_type',
                'assessment_group',
                'type',
                'subject_id',
                'week',
                'month',
                'bn',
                'coy',
                'pl',
                'sec'
            ], 'unique_assessment_record');
        });
    }

    public function down()
    {
        Schema::table('assessments', function (Blueprint $table) {
            $table->dropUnique('unique_assessment_record');
        });
    }
};