<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGpvReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
    Schema::create('gpv_reports', function (Blueprint $table) {
            $table->id();
            $table->string('report_name');
            $table->foreignId('intake_id')->nullable()->constrained('intakes')->onDelete('cascade');
            $table->foreignId('school_id')->nullable()->constrained('schools')->onDelete('cascade');
            $table->foreignId('course_id')->nullable()->constrained('courses')->onDelete('cascade');
            $table->string('phase')->nullable();
            $table->string('bn')->nullable();
            $table->string('coy')->nullable();
            $table->string('pl')->nullable();
            $table->string('grade')->nullable();
            $table->string('army_number')->nullable();
            $table->integer('total_students')->default(0);
            $table->json('filters')->nullable(); // Store all filter parameters
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gpv_reports');
    }
}
