<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGpvReportDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
  Schema::create('gpv_report_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('gpv_report_id')->constrained('gpv_reports')->onDelete('cascade');
            $table->foreignId('admission_id')->constrained('admissions')->onDelete('cascade');
            $table->string('admission_number');
            $table->string('army_number');
            $table->string('rank');
            $table->string('name');
            $table->string('school');
            $table->string('course');
            $table->decimal('theory_score', 8, 2);
            $table->decimal('practical_score', 8, 2);
            $table->decimal('cr_22_score', 8, 2);
            $table->decimal('pr_score', 8, 2);
            $table->decimal('total_score', 8, 2);
            $table->string('grade');
            $table->text('comment')->nullable();
            $table->string('remarks');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gpv_report_details');
    }
}
