<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PhaseConfig;
use App\Models\GradeScale;

class PhaseConfigurationSeeder extends Seeder
{
    public function run()
    {
        // Clear existing data
        PhaseConfig::truncate();
        GradeScale::truncate();

        // Phase configurations
        $phaseConfigs = [
            [
                'phase_name' => 'Phase 1',
                'msk_theory_config' => [
                    'max_score' => 40,
                    'pass_mark' => 20,
                    'obtained' => 0
                ],
                'msk_practical_config' => [
                    'max_score' => 30,
                    'pass_mark' => 15,
                    'obtained' => 0
                ],
                'character_22cr_config' => [
                    'max_score' => 20,
                    'pass_mark' => 10,
                    'obtained' => 0
                ],
                'character_pr_config' => [
                    'max_score' => 10,
                    'pass_mark' => 5,
                    'obtained' => 0
                ],
                'passing_criteria' => [
                    'theory' => 20,
                    'practical' => 15,
                    '22cr' => 10,
                    'pr' => 5
                ],
                'max_scores' => [
                    'theory' => 40,
                    'practical' => 30,
                    '22cr' => 20,
                    'pr' => 10
                ],
                'is_active' => true
            ],
            [
                'phase_name' => 'Phase 2',
                'msk_theory_config' => [
                    'max_score' => 50,
                    'pass_mark' => 25,
                    'obtained' => 0
                ],
                'msk_practical_config' => [
                    'max_score' => 35,
                    'pass_mark' => 17.5,
                    'obtained' => 0
                ],
                'character_22cr_config' => [
                    'max_score' => 10,
                    'pass_mark' => 5,
                    'obtained' => 0
                ],
                'character_pr_config' => [
                    'max_score' => 5,
                    'pass_mark' => 2.5,
                    'obtained' => 0
                ],
                'passing_criteria' => [
                    'theory' => 25,
                    'practical' => 17.5,
                    '22cr' => 5,
                    'pr' => 2.5
                ],
                'max_scores' => [
                    'theory' => 50,
                    'practical' => 35,
                    '22cr' => 10,
                    'pr' => 5
                ],
                'is_active' => false
            ],
            [
                'phase_name' => 'Phase 3',
                'msk_theory_config' => [
                    'max_score' => 40,
                    'pass_mark' => 20,
                    'obtained' => 0
                ],
                'msk_practical_config' => [
                    'max_score' => 40,
                    'pass_mark' => 20,
                    'obtained' => 0
                ],
                'character_22cr_config' => [
                    'max_score' => 15,
                    'pass_mark' => 8,
                    'obtained' => 0
                ],
                'character_pr_config' => [
                    'max_score' => 5,
                    'pass_mark' => 3,
                    'obtained' => 0
                ],
                'passing_criteria' => [
                    'theory' => 20,
                    'practical' => 20,
                    '22cr' => 8,
                    'pr' => 3
                ],
                'max_scores' => [
                    'theory' => 40,
                    'practical' => 40,
                    '22cr' => 15,
                    'pr' => 5
                ],
                'is_active' => false
            ]
        ];

        // Grade scale configuration
        $gradeScales = [
            ['grade' => 'A', 'min_score' => 90, 'comment' => 'EXCELLENT'],
            ['grade' => 'B', 'min_score' => 80, 'comment' => 'VERY GOOD'],
            ['grade' => 'C', 'min_score' => 70, 'comment' => 'GOOD'],
            ['grade' => 'D', 'min_score' => 60, 'comment' => 'SATISFACTORY'],
            ['grade' => 'E', 'min_score' => 50, 'comment' => 'FAIR'],
            ['grade' => 'F', 'min_score' => 0, 'comment' => 'POOR']
        ];

        // Insert the data
        foreach ($phaseConfigs as $config) {
            PhaseConfig::create($config);
        }

        foreach ($gradeScales as $scale) {
            GradeScale::create($scale);
        }
    }
}