#  School Module

The **School Module** in START is the foundational layer where institutions, courses, and intake cycles are managed. It enables UPDF administrators and academic officers to define the academic structure before performance tracking begins.

---

##  1. Add a New School

Schools represent UPDF training institutions such as academies, colleges, or training centers.
![START School Screenshot](/images/school.png)

###  How to Add a School:

1. Go to the **School Management** section.
2. Click on **"Add School"**.
3. Enter the following details:
   - **School Name** (e.g. Bihanga Military Academy)


> ✅ Once created, the school becomes a selectable entity when assigning courses, cadets, or instructors.

---

##  2. Add Courses

Courses represent academic or military training programs offered by a school.

![START School Screenshot](/images/school1.png)

###  How to Add a Course:

1. Inside a specific school, click on **"Courses"** > **"Add New"**
2. Fill in:
   - **Course Title** (e.g. Infantry Tactics 101)
   - **Select School** (like Bihanga Military Academy)

>  Courses are directly linked to evaluations and cadet performance.

---

##  3. Create Intakes

Intakes define the admission cycles or cohorts within a course — for example, “19/25”.

![START School Screenshot](/images/school2.png)


###  How to Create an Intake:

1. Go to the **School Management** section.
2. Click on **"Add Intake"**.
   - **Intake Name** (e.g. 19/25)


>  Intakes organize cadets into batches and help filter performance data by cohorts.


## 4. Add Subjects

**Subjects** are the core academic components in any training program. They define the knowledge areas that cadets must master.
![START School Screenshot](/images/subject.png)
###  How to Add a Subject:

1. Navigate to **School Management** > **Subjects**.
2. Click on **"Add New Subject"**.
3. Enter:
   - **Subject Name** (e.g. Skill At Arms)
   - **Subject Code** (e.g. 	SAA)
   - **Course** (pick a course)
   - **Weight** (e.g. 5)




## 5. Manage Battalion (Bn), Company (Coy), Platoon (Pl), and Section (Sec)

This section allows you to define and manage UPDF units for better organization and reporting.
![START School Screenshot](/images/group.png)
###  Add Battalion (Bn):

1. Navigate to **School Management** > **Grouping**.
2. Click **"Add Bn"** and fill in:
   - **Bn Name**
   - **Rank**
   - **Bn Comd Name**


###  Add Company (Coy):

 Click **"Add Coy"** and fill in:
   - **Select Bn**
   - **Coy Name**
   - **Select Rank**
   - **Coy Comd Name**

###  Add Platoon (Pl):

 Click **"Add Pl"** and fill in:
   - **Select Bn**
   - **Select Coy**
   - **Select Pl**
   - **SelectRank**
   - **Comd Name**
   - **Pl Sgt**
   - **SelectPl Sgt Rank**

###  Add Section (Sec):

 Click **"Add Sec"** and fill in:
   - **Select Bn**
   - **Select Coy**
   - **Select Pl**
   - **Sec Name**
   - **Rank**
   - **Sec Comd Name**



## 6 Add 22CR Items

Administrators can define custom 22CR criteria based on institutional needs.
![START School Screenshot](/images/22cr.png)
###  How to Add 22CR Items:

1. Navigate to **Schooling Module** > **22CR Management**
2. Click **"Add 22CR Item"**
3. Provide the following:
   - **Title** (e.g. Performing successfully under physical stree)
   - **Weight** (eg 5)
   - **Phase** (e.g. Phase 1)


4. Click **Save**

> 🔄 Once added, these items become part of cadet evaluation forms and are visible in the performance reports.


##  7. Phase Configuration

This is where you set the **Grade Scales** and other key metrics for evaluating cadets.

###  Create/Modify Phase Configurations:

![START School Screenshot](/images/phase-config.png)

1. Navigate to **Phase Configuration**.
2. You will see a table with the following columns:
   - **Phase Name**
   - **Theory (Max/Pass)**
   - **Practical (Max/Pass)**
   - **22CR (Max/Pass)**
   - **PR (Max/Pass)**
   - **Status** (Active/Inactive)
   - **Actions** (Edit/Delete)

3. Click **"Create New Phase"** or **"Edit"** for existing phases to modify settings.

> ⚠️ **Warning**: Editing these configurations will directly impact all student evaluations. Please ensure any changes are carefully reviewed and approved by the proper authorities.

---






 

