# 📝 Admissions Management

The **Admissions Module** in START allows you to view, add, import, and manage cadet records across all UPDF academic institutions. This is the central source of truth for all enrolled cadets and their training affiliations.

---

![START School Screenshot](/images/admission.png)

## 📋 Admissions List

This is the master list of cadets currently admitted into the system. From here, admins can search, filter, edit, delete, or export cadet records.

### Columns:

| # | Admission ID | Army Number | Rank | Cadet Name | School | Course | Actions |
|---|--------------|-------------|------|------------|--------|--------|---------|
| 1 | 1001         | UP12345      | Pte  | John Doe   | Kabamba Academy | Basic Infantry | Edit/Delete |

---

## ➕ Add New Admission

You can manually admit cadets into the system using a guided form.

### Steps:

1. Click **"Add New Admission"**
2. Fill in:
   - **Army Number**
   - **Rank**
   - **Full Name**
   - **School**
   - **Course**
   - **Intake**
   - **Bn / Coy / Pl / Sec** (unit structure)
3. Click **Save**

---

## 📥 Import Admissions (Bulk)

You can bulk-upload cadets using a pre-formatted Excel template.

### Instructions:

1. Click **"Download Template"** to get the required format.
2. Fill out the template with cadet details.
3. Click **"Choose File"** to upload the Excel sheet.
4. Click **Import**

> ✅ The system will validate data before inserting. Errors will be highlighted for correction.

---

## 📤 Export to Excel

Need to download the current admissions list?

- Click **"Export Excel"** to download the full admissions data in spreadsheet format.

---

## 🔍 Filter & Search

Use advanced filters to narrow down the admissions list by institution or military structure.

### Available Filters:

- **School**
- **Course**
- **Battalion (Bn)**
- **Company (Coy)**
- **Platoon (Pl)**
- **Section (Sec)**

### Search Options:

- **Army Number**
- **Cadet Name**

Click **"Filter"** or **"Search"** to apply.

---

## 🧹 Bulk Delete

You can delete multiple admissions at once.

### How:

1. Select the checkboxes beside each cadet.
2. Click **"Bulk Delete"**
3. Confirm action.

>  This will permanently remove all selected records. Use with caution.

---

##  Summary

The **Admissions List** is critical for:
- Tracking cadet intake by year, course, and unit
- Generating reports and attendance sheets
- Managing bulk enrollments efficiently

---


