#  Track Activity

![Track Activity Table](/images/track.png)

The **Track Activity** module provides a secure and auditable trail of user actions across the START system. It ensures transparency, system accountability, and aids in troubleshooting or administrative reviews.

---

##  Purpose

This module is essential for:

- **Security auditing**
- **System usage analysis**
- **User behavior monitoring**
- **Incident investigation**

---

##  Filtering Options

Users can filter activity logs by:

- **Action**: Login, Logout, Add, Edit, Delete, Import, Export, etc.
- **Date From**: Start date of log period (e.g., `05/01/2025`)
- **Date To**: End date of log period (e.g., `05/14/2025`)

###  Controls:

- `Filter` – Apply selected filters
- `Reset` – Clear filters and show all records

---

##  Log Table Format

| Time               | User      | Action | Details | IP    |
|--------------------|-----------|--------|---------|--------|
| 2025-05-14 09:57:47| John Doe  | Login  | -       | ::1    |
| 2025-05-14 10:05:22| Admin01   | Add    | New Cadet RA/232555 | 192.168.0.3 |
| 2025-05-14 10:15:09| CmdtNaluk | Delete | Phase: Alpha 1 | 192.168.0.10 |

>  **Note:** Internal IPs (`::1`, `127.0.0.1`) represent local or development access.

---

##  Role-Based Access

| Role        | Can View Activity Log |
|-------------|------------------------|
| Admin       | ✅ Full access          |
| Commandant  | ❌ |
| Instructor  | ❌                     |
| Cadet       | ❌                     |

---

##  Best Practices

- **Regularly audit** the activity log for unusual patterns or unauthorized access attempts.
- Export and archive logs monthly for long-term compliance.
- Review prior to major assessments or system configuration changes.

---

##  Example Use Cases

- **Investigating a deleted assessment**
- **Verifying who added a new course**
- **Confirming cadet record imports**
- **Tracing login attempts during off-hours**

---



