@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Record</h2>

    <form action="{{ route('twenty_two_cr.update', $record->id) }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf
        @method('PUT')

      @php
        $titles = [
            "Performing successfully under physical stress",
            "Performing successfully under emotional stress",
            "Knowing the job",
            "Applying his knowledge",
            "Telling the truth",
            "Acting Honestly",
            "Admitting mistakes",
            "Accepting criticism",
            "Learning from experience",
            "Assuming responsibility",
            "Taking action on his own",
            "Ensuring assigned tasks understood",
            "Ensuring supervision and completion of tasks",
            "Complying with rules and orders even though he/she disagrees",
            "Supporting superiors and associates even though he/she disagrees",
            "Expressing self clearly Orally",
            "Expressing self clearly in Writing",
            "Making effort to co-operate and work as team member...",
            "Maintaining high standards of appearance and hygiene...",
            "Maintaining good personal habits and manners",
            "Delegating tasks to others",
            "Maintaining and increasing team performance"
        ];
        @endphp

        <div class="mb-4">
            <label for="title" class="block text-gray-700 font-semibold mb-2">Title</label>
            <select name="title" id="title" class="w-full p-3 border border-gray-300 rounded" required>
                <option value="">Select Title</option>
                @foreach ($titles as $title)
                    <option value="{{ $title }}" {{ $record->title === $title ? 'selected' : '' }}>{{ $title }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-4">
            <label for="weight" class="block text-gray-700 font-semibold mb-2">Weight</label>
            <input type="number" step="0.01" name="weight" id="weight" value="{{ $record->weight }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>

        <div class="mb-4">
            <label for="phase" class="block text-gray-700 font-semibold mb-2">Phase</label>
            <select name="phase" id="phase" class="w-full p-3 border border-gray-300 rounded" required>
                <option value="">Select Phase</option>
                @foreach ($phases as $phase)
                    <option value="{{ $phase->name }}" {{ $record->phase === $phase->name ? 'selected' : '' }}>
                        {{ $phase->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="flex gap-4">
            <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Update Record</button>
            <a href="{{ route('twenty_two_cr.index') }}" class="bg-gray-500 text-white px-6 py-3 rounded hover:bg-gray-600">Cancel</a>
        </div>
    </form>
</div>
@endsection
