@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">22CR</h1>
            <p class="text-gray-600">Add or filter 22CR items</p>
        </div>
        <a href="{{ route('twenty_two_cr.create') }}" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Add New Record</a>
    </div>

    <!-- Phase Filter Form -->
    <form method="GET" action="{{ route('twenty_two_cr.index') }}" class="mb-6">
        <div class="flex items-center gap-4">
            <select name="phase" class="p-3 border border-gray-300 rounded">
                <option value="">-- Filter by Phase --</option>
                @foreach($phases as $phase)
                    <option value="{{ $phase->name }}" {{ request('phase') == $phase->name ? 'selected' : '' }}>
                        {{ $phase->name }}
                    </option>
                @endforeach
            </select>
            <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded hover:bg-gray-900">Filter</button>
            <a href="{{ route('twenty_two_cr.index') }}" class="text-blue-500 hover:underline">Reset</a>
        </div>
    </form>

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <table class="min-w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Title</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Weight</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phase</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($records as $index => $record)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $index+1 }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $record->title }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $record->weight }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $record->phase }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <a href="{{ route('twenty_two_cr.edit', $record->id) }}" class="text-blue-600 hover:text-blue-900 mr-3">Edit</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
