@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
  <div class="flex justify-between items-center mb-8">
    <div>
        <h1 class="text-4xl font-bold text-gray-800">22 CR Overview</h1>
        <p class="text-gray-600">View and filter cadet performance by school, course, battalion, company, and platoon. <br> Sort and apply filters, then print or export results as PDF.</p>
    </div>
</div>


    <!-- Search Form -->
    <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-8">
        <form method="GET" action="{{ route('cr.assessments.22cr.overview') }}" class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4">
                <!-- School Filter -->
                <div>
                    <label for="school_id" class="block text-sm font-medium text-gray-700">School</label>
                    <select name="school_id" id="school_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Schools</option>
                        @foreach($schools as $school)
                            <option value="{{ $school->id }}" {{ request('school_id') == $school ? 'selected' : '' }}>{{ $school->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Course Filter -->
                <div>
                    <label for="course_id" class="block text-sm font-medium text-gray-700">Course</label>
                    <select name="course_id" id="course_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Courses</option>
                        @foreach($courses as $course)
                            <option value="{{ $course->id }}" {{ request('course_id') == $course->name ? 'selected' : '' }}>{{ $course->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Battalion Filter -->
                <div>
                    <label for="bn" class="block text-sm font-medium text-gray-700">Battalion</label>
                    <select name="bn" id="bn" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Battalions</option>
                        @foreach($battalions as $battalion)
                            <option value="{{ $battalion }}" {{ request('bn') == $battalion ? 'selected' : '' }}>{{ $battalion }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Company Filter -->
                <div>
                    <label for="coy" class="block text-sm font-medium text-gray-700">Company</label>
                    <select name="coy" id="coy" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Companies</option>
                        @foreach($coysList as $coy)
                            <option value="{{ $coy }}" {{ request('coy') == $coy ? 'selected' : '' }}>{{ $coy }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Platoon Filter -->
                <div>
                    <label for="pl" class="block text-sm font-medium text-gray-700">Platoon</label>
                    <select name="pl" id="pl" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Platoons</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                 
                    </select>
                </div>
                
                <!-- Section Filter -->
                {{-- <div>
                    <label for="sec" class="block text-sm font-medium text-gray-700">Section</label>
                    <select name="sec" id="sec" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Sections</option>
                        @foreach($sections as $sec)
                            <option value="{{ $sec }}" {{ request('sec') == $sec ? 'selected' : '' }}>{{ $sec }}</option>
                        @endforeach
                    </select>
                </div> --}}
                
                <!-- Sort Direction Filter -->
                <div>
                    <label for="sort" class="block text-sm font-medium text-gray-700">Sort Direction</label>
                    <select name="sort" id="sort" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">Default</option>
                        <option value="asc" {{ request('sort') == 'asc' ? 'selected' : '' }}>Ascending (A-Z)</option>
                        <option value="desc" {{ request('sort') == 'desc' ? 'selected' : '' }}>Descending (Z-A)</option>
                        <option value="score_asc" {{ request('sort') == 'score_asc' ? 'selected' : '' }}>Score (Low to High)</option>
                        <option value="score_desc" {{ request('sort') == 'score_desc' ? 'selected' : '' }}>Score (High to Low)</option>
                    </select>
                </div>
            </div>
            <div class="flex justify-end mt-4">
                <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                    Apply Filters
                </button>
            </div>
          <div class="flex flex-wrap gap-4 mt-4">

                    <!-- Apply Filters Button -->
                
                
                    <!-- Reset Filters Link -->
                    <div>
                        <a href="{{ route('cr.assessments.22cr.overview') }}"
                            class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-400 focus:ring-offset-2">
                            Reset Filters
                        </a>
                    </div>
                
                    <!-- Print PDF Link -->
                    <div>
                        <a href="{{ route('admissions.print22c', [
                            'pl' => request('pl'),
                            'coy' => request('coy'),
                            'sec' => request('sec'),
                            'bn' => request('bn'),
                            'school_id' => request('school_id'),
                            'course_id' => request('course_id'),
                            'intake_id' => request('intake_id'),
                            'year_admission' => request('year_admission'),
                            'student_id' => request('student_id'),
                            'sort' => request('sort', 'default')
                        ]) }}"
                        target="_blank"
                        class="bg-green-600 text-white px-4 py-2 rounded-md font-semibold shadow hover:bg-green-700 transition">
                            Print PDF
                        </a>
                    </div>
                
                </div>
        </form>
    
        
        
  
    </div>

    {{-- <!-- Platoon Performance Summary -->
    @if(isset($platoonScores) && count($platoonScores) > 0)
        <div class="mb-8 bg-white rounded-lg shadow-lg overflow-hidden">
            <div class="bg-blue-600 text-white px-6 py-4">
                <h3 class="text-xl font-semibold">Platoon Performance Summary</h3>
            </div>
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <!-- Best Platoon -->
                    <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                        <h4 class="text-lg font-semibold text-green-800 mb-2">Best Performing Platoon</h4>
                        <div class="flex justify-between items-center">
                            <span class="text-xl font-bold text-green-700">{{ $bestPlatoon ?? 'N/A' }}</span>
                            <span class="text-sm bg-green-200 text-green-800 px-3 py-1 rounded-full">
                                {{ isset($platoonScores[$bestPlatoon]) ? number_format($platoonScores[$bestPlatoon]['average'], 2) . '% /20%' : 'N/A' }}
                            </span>
                        </div>
                    </div>

                    <!-- Worst Platoon -->
                    <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                        <h4 class="text-lg font-semibold text-red-800 mb-2">Worst Performing Platoon</h4>
                        <div class="flex justify-between items-center">
                            <span class="text-xl font-bold text-red-700">{{ $worstPlatoon ?? 'N/A' }}</span>
                            <span class="text-sm bg-red-200 text-red-800 px-3 py-1 rounded-full">
                                {{ isset($platoonScores[$worstPlatoon]) ? number_format($platoonScores[$worstPlatoon]['average'], 2) . '% /20%' : 'N/A' }}
                            </span>
                        </div>
                    </div>

                    <!-- Current Filter -->
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                        <h4 class="text-lg font-semibold text-blue-800 mb-2">Current Filter</h4>
                        <div class="flex justify-between items-center">
                            <span class="text-xl font-bold text-blue-700">{{ $platoon ?: 'All Platoons' }}</span>
                            <span class="text-sm bg-blue-200 text-blue-800 px-3 py-1 rounded-full">
                                {{ $sortBy == 'best' ? 'Best First' : ($sortBy == 'worst' ? 'Worst First' : 'Default') }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
  <!-- Detailed Platoon Performance with Best/Worst Students -->
  <div class="mb-6">
    <h3 class="text-lg font-bold mb-3">Platoon Performance Details</h3>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        @foreach($platoonScores as $pl => $plData)
            <div class="bg-white rounded shadow overflow-hidden">
                <div class="bg-gray-100 px-4 py-2 border-b border-gray-200">
                    <div class="flex justify-between items-center">
                        <h4 class="text-base font-semibold">Platoon: {{ $pl }}</h4>
                        <span class="text-xs bg-blue-100 text-blue-800 px-2 py-0.5 rounded-full">
                            {{ number_format($plData['average'], 2) }}% /20%
                        </span>
                    </div>
                </div>
                <div class="p-3">
                    <!-- Best student -->
                    <div class="mb-2">
                        <h5 class="text-xs font-medium text-gray-700 mb-1">Best Student</h5>
                        <div class="bg-green-50 border border-green-200 rounded p-2">
                            <div class="flex justify-between">
                                <div>
                                    <p class="text-sm font-semibold">{{ $plData['bestStudent']['name'] }}</p>
                                    <p class="text-xs text-gray-600">{{ $plData['bestStudent']['army_number'] }}</p>
                                </div>
                                <span class="text-xs bg-green-200 text-green-800 px-2 py-0.5 rounded-full">
                                    {{ number_format($plData['bestStudent']['score'], 2) }}% /20%
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Worst student -->
                    <div>
                        <h5 class="text-xs font-medium text-gray-700 mb-1">Worst Student</h5>
                        <div class="bg-red-50 border border-red-200 rounded p-2">
                            <div class="flex justify-between">
                                <div>
                                    <p class="text-sm font-semibold">{{ $plData['worstStudent']['name'] }}</p>
                                    <p class="text-xs text-gray-600">{{ $plData['worstStudent']['army_number'] }}</p>
                                </div>
                                <span class="text-xs bg-red-200 text-red-800 px-2 py-0.5 rounded-full">
                                    {{ number_format($plData['worstStudent']['score'], 2) }}% /20%
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div> --}}
    <!-- Show results only if search was performed -->
    @if($assessments->count() > 0)

    <div class="relative flex flex-col w-full h-full overflow-scroll text-gray-700 bg-white shadow-md rounded-xl bg-clip-border">
        <table class="w-full text-left table-auto min-w-max">
            <thead>
                <tr>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                      SN
                    </p>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <a href="{{ request()->fullUrlWithQuery(['sort' => request('sort') == 'asc_army' ? 'desc_army' : 'asc_army']) }}" class="flex items-center cursor-pointer">
                      <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                        Army Number
                      </p>
                      @if(request('sort') == 'asc_army')
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                        </svg>
                      @elseif(request('sort') == 'desc_army')
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                      @endif
                    </a>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                      Rank
                    </p>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <a href="{{ request()->fullUrlWithQuery(['sort' => request('sort') == 'asc' ? 'desc' : 'asc']) }}" class="flex items-center cursor-pointer">
                      <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                        Cadet Name
                      </p>
                      @if(request('sort') == 'asc')
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                        </svg>
                      @elseif(request('sort') == 'desc')
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                      @endif
                    </a>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                      Phase
                    </p>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <a href="{{ request()->fullUrlWithQuery(['sort' => request('sort') == 'score_asc' ? 'score_desc' : 'score_asc']) }}" class="flex items-center cursor-pointer">
                      <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                        22CR Score
                      </p>
                      @if(request('sort') == 'score_asc')
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                        </svg>
                      @elseif(request('sort') == 'score_desc')
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                      @endif
                    </a>
                  </th>
                </tr>
              </thead>
          <tbody>
            @php $cadetCounter = 1; @endphp
            @foreach($assessments as $armyNumber => $armyAssessments)
              @foreach($armyAssessments as $index => $assessment)
                <tr class="{{ $index === count($armyAssessments)-1 && !$loop->parent->last ? 'border-b-2 border-blue-gray-100' : '' }}">
                  @if($index === 0)
                    <td class="p-4 border-b border-blue-gray-50" rowspan="{{ count($armyAssessments) }}">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        {{ $cadetCounter }}
                      </p>
                    </td>
                    <td class="p-4 border-b border-blue-gray-50" rowspan="{{ count($armyAssessments) }}">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        {{ $armyNumber }}
                      </p>
                    </td>
                    <td class="p-4 border-b border-blue-gray-50" rowspan="{{ count($armyAssessments) }}">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        O/CDT
                      </p>
                    </td>
                    <td class="p-4 border-b border-blue-gray-50" rowspan="{{ count($armyAssessments) }}">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        {{ $assessment->name }}
                      </p>
                    </td>
                    @php $cadetCounter++; @endphp
                  @endif
                  <td class="p-4 border-b border-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                      {{ $assessment->phase }}
                    </p>
                  </td>
                  <td class="p-4 border-b border-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-semibold leading-normal text-blue-700">
                      @php
                      $totalCRES = 0;
                      foreach($assessment->assessmentDetails as $detail) {
                          // Calculate individual f and fx
                          $f = $detail->f1 + $detail->f2 + $detail->f3 + $detail->f4 + $detail->f5;
                          $fx = ($detail->f1 * 1) + ($detail->f2 * 2) + ($detail->f3 * 3) +
                                ($detail->f4 * 4) + ($detail->f5 * 5);
            
                          // Calculate individual CRES
                          if ($f > 0) {
                              $individualCRES = ($fx / $f) * $detail->twentyTwoCR->weight;
                              $totalCRES += $individualCRES;
                          }
                      }
                      $score = number_format(($totalCRES / 720) * 20, 2);
                      @endphp
                      {{ $score }}% /20%
                    </p>
                  </td>
                </tr>
              @endforeach
            @endforeach
          </tbody>
        </table>
      </div>

    @else
        <!-- No results found -->
        <div class="bg-white rounded-lg shadow-lg overflow-hidden">
            <div class="p-6 text-center">
                <div class="text-gray-500 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <h3 class="text-xl font-medium text-gray-900 mb-2">No Records Found</h3>
                    <p>No 22 CR records were found {{  "for Platoon ". $platoon }}</p>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection

@push('scripts')
<script>
function viewDetails(assessmentId) {
    const detailsRow = document.getElementById(`details_${assessmentId}`);
    detailsRow.classList.toggle('hidden');
}
</script>
@endpush