@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Import Admissions</div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger">
                            @if(is_array(session('error')))
                                <ul>
                                @foreach(session('error') as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                                </ul>
                            @else
                                {{ session('error') }}
                            @endif
                        </div>
                    @endif

                    <form action="{{ route('admissions.import') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="file">Choose Excel File</label>
                            <input type="file" class="form-control-file" id="file" name="file" required>
                            <small class="form-text text-muted">
                                Required columns: name, army_number, school_id, course_id<br>
                                Optional columns: intake_id, student_id, email, phone_number, rank, MIL_ID_No, 
                                year_admission, bn_regt, coy, pl, sec
                            </small>
                            @error('file')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-primary mt-3">Import</button>
                    </form>

                    <div class="mt-4">
                        <h5>Sample Excel Format:</h5>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>name</th>
                                    <th>army_number</th>
                                    <th>school_id</th>
                                    <th>course_id</th>
                                    <th>rank</th>
                                    <!-- Add other columns as needed -->
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>John Doe</td>
                                    <td>ARM123</td>
                                    <td>1</td>
                                    <td>1</td>
                                    <td>Private</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection