@extends('layouts.app')

@section('content')
<!-- Loading Overlay -->
<div id="loading-overlay" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex justify-center items-center hidden z-50">
    <div class="text-center">
        <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-white"></div>
        <p class="text-white mt-4">Importing... Please wait</p>
    </div>
</div>

<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Title and Add New Button -->
    <!-- Add this after the "Add New Admission" button -->
    <div class="flex justify-between items-center mb-6">
      
            
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-4xl font-bold text-gray-800">Admissions List</h1>
                <p class="text-gray-600">View and manage the list of admitted cadets</p>
            </div>
        </div>
        
        <div class="flex space-x-2">
            <a href="{{ route('admissions.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                Add New Admission
            </a>
            {{-- <a href="{{ route('admissions.export') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                Export Excel
            </a> --}}
            {{-- <a href="{{ route('admissions.print', array_merge(request()->all(), ['preview' => true])) }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                Print PDF
            </a> --}}
        </div>
    </div>
   
        <!-- Success Message -->
        @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
        <script>
            setTimeout(function() {
                document.querySelector('.bg-green-100').style.display = 'none';
            }, 5000); // Hide success message after 5 seconds
        </script>
        @endif

        <!-- Import Statistics -->
        @if(session('stats'))
        <div class="alert alert-info bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded mb-4">
            <h5>Import Statistics:</h5>
            <ul>
                <li>Total Rows Processed: {{ session('stats.total_processed') }}</li>
                <li>Successfully Imported: {{ session('stats.successful') }}</li>
                <li>Failed: {{ session('stats.failed') }}</li>
                <li>Processing Time: {{ number_format(session('stats.processing_time'), 2) }} seconds</li>
            </ul>
        </div>
        <script>
            document.querySelector('.alert').classList.add('fade-in');
        </script>
        @endif

        <!-- Import File Section -->
        <div class="flex space-x-2 mb-4">
            <a href="{{ route('admissions.downloadTemplate') }}">
                <button class="bg-blue-500 text-white py-2 px-4 rounded hover:bg-gray-600">
                    Download Template
                </button>
            </a>

            <form action="{{ route('admissions.import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label for="file">Choose File</label>
                    <input type="file" name="file" class="form-control" required>
                </div>
                <button type="submit" class="bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">
                    Import
                </button>
            </form>
        </div>
<!-- Combined Search and Filter Form -->
<form method="GET" action="{{ route('admissions.index') }}" class="mb-4 flex flex-wrap gap-4">
    <!-- Search input -->
    <div class="relative w-full md:w-1/3">
        <input type="text" name="search" placeholder="Search by Army Number, Name"
            value="{{ request('search') }}"
            class="w-full border-gray-300 rounded-lg shadow-sm p-2 pl-10">
        <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 0l7 7"></path>
        </svg>
    </div>
    
    <!-- Filters -->
    <select name="school_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by School</option>
        @foreach($schools as $school)
            <option value="{{ $school->id }}" {{ request('school_id') == $school->id ? 'selected' : '' }}>{{ $school->name }}</option>
        @endforeach
    </select>
    
    <select name="course_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Course</option>
        @foreach($courses as $course)
            <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>{{ $course->name }}</option>
        @endforeach
    </select>

    <select name="bn" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Bn</option>
        @foreach($bn as $bns)
        @foreach([$bns] as $bnRegt)
        <option value="{{ $bnRegt }}" {{ request('bn') == $bnRegt ? 'selected' : '' }}>{{ ucfirst($bnRegt) }}</option>
        @endforeach
        @endforeach
    </select>
    
    <select name="coy" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Coy</option>
        @foreach($coy as $coys)
        @foreach([$coys] as $coyss)
            <option value="{{ $coyss }}" {{ request('coy') == $coyss ? 'selected' : '' }}>{{ strtoupper($coyss) }}</option>
        @endforeach
        @endforeach
    </select>
    
<select name="pl" class="border-gray-300 rounded-lg p-2">
    <option value="">Filter by PL</option>
    @for($i = 1; $i <= 3; $i++)
        <option value="{{ $i }}" {{ request('pl') == $i ? 'selected' : '' }}>
            {{ $i }}
        </option>
    @endfor
</select>

    
    <select name="sec" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Sec</option>
        @foreach($sec as $secs)
        @foreach([$secs] as $sec)
            <option value="{{ $sec }}" {{ request('sec') == $sec ? 'selected' : '' }}>{{ $sec }}</option>
        @endforeach
        @endforeach
    </select>
    
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
        Apply Filters & Search
    </button>
    
    <!-- Clear filters button -->
    <a href="{{ route('admissions.index') }}" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-300">
        Clear All
    </a>
</form>

        <!-- Bulk Delete Form -->
        <form id="bulk-delete-form" action="{{ route('admissions.bulkDelete') }}" method="POST">
            @csrf
            @method('DELETE')
            <div class="flex justify-between items-center mb-4">
                @if(Auth::user()->type == 'admin')
                    <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700" onclick="return confirm('Are you sure you want to delete selected records?');">
                        Bulk Delete
                    </button>
                @endif
            </div>
            
            <div class="text-sm text-gray-700">
                Showing 
                <span class="font-medium">{{ $admissions->firstItem() ?? 0 }}</span>
                to 
                <span class="font-medium">{{ $admissions->lastItem() ?? 0 }}</span>
                of 
                <span class="font-medium">{{ $admissions->total() }}</span>
                results
            </div>
            <!-- Admissions Table -->
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                
                                <th class="px-6 py-3">#</th> <!-- Serial number column -->
                                <th class="px-6 py-3">
                                    <input type="checkbox" id="select-all" class="select-all-checkbox">
                                </th>
                        

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=admission_id&direction={{ request('direction') == 'asc' ? 'desc' : 'asc' }}">
                                        Admission ID
                                        @if(request('sort') == 'admission_id')
                                            @if(request('direction') == 'asc')
                                                ▲
                                            @else
                                                ▼
                                            @endif
                                        @endif
                                    </a>
                                </th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=army_number&direction={{ request('direction') == 'asc' ? 'desc' : 'asc' }}">
                                        Army Number
                                        @if(request('sort') == 'army_number')
                                            @if(request('direction') == 'asc')
                                                ▲
                                            @else
                                                ▼
                                            @endif
                                        @endif
                                    </a>
                                </th>
                                
                                {{-- <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Army Number</th> --}}
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rank</th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=name&direction={{ request('direction') == 'asc' ? 'desc' : 'asc' }}">
                                        Cadet Name
                                        @if(request('sort') == 'name')
                                            @if(request('direction') == 'asc')
                                                ▲
                                            @else
                                                ▼
                                            @endif
                                        @endif
                                    </a>
                                </th>
                            
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">School</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Course</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($admissions as $index => $admission)
                            <tr>
                                <!-- Adjusted numbering based on pagination -->
                                <td class="px-6 py-4">{{ $admissions->firstItem() + $index }}</td>
                                <td class="px-6 py-4">
                                    <input type="checkbox" name="selected_ids[]" value="{{ $admission->id }}" class="select-item">
                                </td>
                                <td class="px-6 py-4">{{ $admission->admission_id }}</td>
                                <td class="px-6 py-4">{{ $admission->army_number }}</td>
                                <td class="px-6 py-4">{{ $admission->rank }}</td>
                                <td class="px-6 py-4">{{ $admission->name }}</td>
                                <td class="px-6 py-4">{{ $admission->school->name }}</td>
                                <td class="px-6 py-4">{{ $admission->course->name }}</td>
                                <td class="px-6 py-4">
                                    <a href="{{ route('admissions.show', $admission) }}" class="text-green-600 hover:text-blue-900">View</a>
                                    <a href="{{ route('admissions.edit', $admission) }}" class="text-blue-600 hover:text-blue-900">Edit</a>
                                    <form action="{{ route('admissions.destroy', $admission) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this admission?');">
                                        @csrf
                                        @method('DELETE')
                                        @if(Auth::user()->type == 'admin')
                                        <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                                        @endif
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    
                    <!-- Pagination Links -->
                   
                    
                </div>
            </div>
        </form>

        <!-- Pagination -->
    <!-- Pagination -->

 
    <div>
        {{ $admissions->withQueryString()->links() }}
    </div>

        <!-- Rows Per Page -->
        <form method="GET" action="{{ route('admissions.index') }}" class="mb-4 flex space-x-2 mt-10">
            <select name="per_page" onchange="this.form.submit()" class="border-gray-300 rounded-lg p-2">
                @foreach([25, 50, 100, 250, 500] as $size)
                    <option value="{{ $size }}" {{ request('per_page', 25) == $size ? 'selected' : '' }}>
                        Show {{ $size }} rows
                    </option>
                @endforeach
            </select>
        </form>
    </div>
</div>

<script>
    // Select all checkboxes logic
    document.addEventListener("DOMContentLoaded", function () {
        const selectAllCheckbox = document.getElementById('select-all');
        const rowCheckboxes = document.querySelectorAll('input[type="checkbox"].select-item');

        selectAllCheckbox.addEventListener("change", function () {
            rowCheckboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });
        });

        rowCheckboxes.forEach(checkbox => {
            checkbox.addEventListener("change", function () {
                if (![...rowCheckboxes].some(chk => chk.checked)) {
                    selectAllCheckbox.checked = false;
                }
            });
        });
    });
</script>

@endsection
