<!DOCTYPE html>
<html>
<head>
    <title>Admissions List</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .filters { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px;}
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { margin-bottom: 20px; }
        .date { text-align: right; margin-bottom: 10px; }
        .logo { height: 60px; margin-bottom: 10px; }
        .title { text-align: center; margin-top: 100px; }
        .info { margin-bottom: 20px; }
        .info-item { margin: 5px 0; }

        header {
            position: fixed;
            top: 0cm;
            left: 0cm;
            right: 0cm;
            height: 3cm;

            text-align: center; /* Optional: Center content */
            line-height: 3cm; /* Optional: Vertically center text */
        }

        /* Define the footer rules */
        footer {
            position: fixed;
            bottom: 0cm;
            left: 0cm;
            right: 0cm;
            height: 2cm;

            text-align: center; /* Optional: Center content */
            line-height: 2cm; /* Optional: Vertically center text */
        }
    </style>
</head>
<body>

<header class="site-header">
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</header>



<footer>
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</footer>

<main>

    <div class="header">
        {{--        <img src="{{ asset('bmts-logo1.png') }}" alt="School Logo" class="logo">--}}
        <h2 class="title">Admissions List</h2>

        <div class="info">
            @if(!empty($filters['course_id']))
                <div class="info-item"><strong>Course:</strong> {{ App\Models\Course::find($filters['course_id'])->name }}</div>
            @endif
            @if(!empty($filters['bn']))
                <div class="info-item"><strong>Bn:</strong> {{ $filters['bn'] }}</div>
            @endif
            <div class="date">Generated on: {{ date('Y-m-d H:i:s') }}</div>
        </div>
    </div>

    @if(!empty($filters))
        <div class="filters">
            <h4>Other Details:</h4>
            <ul>
                @if(!empty($filters['school_id']))
                    <li>School: {{ App\Models\School::find($filters['school_id'])->name }}</li>
                @endif
                @if(!empty($filters['coy']))
                    <li>Coy: {{ $filters['coy'] }}</li>
                @endif
                @if(!empty($filters['pl']))
                    <li>Pl: {{ $filters['pl'] }}</li>
                @endif
                @if(!empty($filters['sec']))
                    <li>Sec: {{ $filters['sec'] }}</li>
                @endif
                @if(!empty($filters['search']))
                    <li>Search: {{ $filters['search'] }}</li>
                @endif
            </ul>
        </div>
    @endif

    <table>
        <thead>
        <tr>
            <th>Army Number</th>
            <th>Rank</th>
            <th>Name</th>
            <th>Coy</th>
            <th>Pl</th>
            <th>Sec</th>
        </tr>
        </thead>
        <tbody>
        @foreach($admissions as $admission)
            <tr>
                <td>{{ $admission->army_number }}</td>
                <td>{{ $admission->rank }}</td>
                <td>{{ $admission->name }}</td>
                <td>{{ $admission->coy }}</td>
                <td>{{ $admission->pl }}</td>
                <td>{{ $admission->sec }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <div>Total Records: {{ $admissions->count() }}</div>
</main>

</body>
</html>
