<table class="min-w-full divide-y divide-gray-200">
    <thead class="bg-gray-50">
        <tr>

            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Group Name</th>
            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white divide-y divide-gray-200">
        @forelse($items as $item)
            <tr class="hover:bg-gray-50 transition-colors duration-200">

                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $item->name }}</td>
                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                    <div class="flex justify-end space-x-2">
                        <a href="{{ route($type.'.edit', $item) }}"
                           class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600 transition-colors duration-200">
                            Edit
                        </a>
                        <form action="{{ route($type.'.destroy', $item) }}" method="POST" class="inline-block">
                            @csrf
                            @method('DELETE')
                            <button type="submit"
                                    class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600 transition-colors duration-200"
                                    onclick="return confirm('Are you sure you want to delete this {{ $type }}?')">
                                Delete
                            </button>
                        </form>
                    </div>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="{{ isset($showParent) && $showParent ? 4 : 3 }}" class="px-6 py-4 text-center text-gray-500">
                    No records found
                </td>
            </tr>
        @endforelse
    </tbody>
</table>
