@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Courses List</h2>

    <a href="{{ route('courses.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600 mb-4 inline-block">Add Course</a>

    @if(session('success'))
        <div class="bg-green-500 text-white p-4 mb-4 rounded">
            {{ session('success') }}
        </div>
    @endif

    <table class="min-w-full bg-white border border-gray-300 rounded-lg mt-6">
        <thead>
            <tr>
                <th class="px-6 py-3 text-left">Course ID</th>
                <th class="px-6 py-3 text-left">Course Name</th>
                <th class="px-6 py-3 text-left">School</th>
                <th class="px-6 py-3 text-left">Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($courses as $course)
                <tr class="border-b border-gray-200">
                    <td class="px-6 py-4">{{ $course->id }}</td>
                    <td class="px-6 py-4">{{ $course->name }}</td>
                  
                    <td class="px-6 py-4">{{ $course->school->name }}</td>
                    <td class="px-6 py-4">
                        <a href="{{ route('courses.edit', $course) }}" class="bg-yellow-500 text-white px-3 py-2 rounded hover:bg-yellow-600">Edit</a>
                        <form action="{{ route('courses.destroy', $course) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-red-500 text-white px-3 py-2 rounded hover:bg-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
