@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto px-4 py-8">
    <div class="bg-white shadow-lg rounded-2xl overflow-hidden">
        <div class="bg-gray-100 px-6 py-4 border-b">
            <h4 class="text-xl font-semibold text-gray-700">Import CR Assessments</h4>
        </div>

        <div class="p-6">
            {{-- Success Message --}}
            @if(session('success'))
                <div class="mb-4 p-4 rounded-lg bg-green-100 text-green-800">
                    {{ session('success') }}
                </div>
            @endif

            {{-- Error Message --}}
            @if(session('error'))
                <div class="mb-4 p-4 rounded-lg bg-red-100 text-red-800">
                    {{ session('error') }}
                </div>
            @endif

            {{-- Import Errors --}}
            @if(session('import_errors'))
                <div class="mb-4 p-4 rounded-lg bg-yellow-100 text-yellow-800">
                    <h5 class="font-semibold mb-2">Import completed with errors:</h5>
                    <ul class="list-disc list-inside space-y-1">
                        @foreach(session('import_errors') as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('cr.import') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
                @csrf

                {{-- Phase Selection --}}
                <div>
                    <label for="phase_id" class="block text-sm font-medium text-gray-700 mb-1">Phase</label>
                    <select name="phase_id" id="phase_id" required
                        class="w-full border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select Phase</option>
                        @foreach($phases as $phase)
                            <option value="{{ $phase->id }}" 
                                {{ $activePhase && $phase->id == $activePhase->id ? 'selected' : '' }}>
                                {{ $phase->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- File Upload --}}
                <div>
                    <label for="import_file" class="block text-sm font-medium text-gray-700 mb-1">Excel File</label>
                    <input type="file" name="import_file" id="import_file" accept=".xlsx,.xls,.csv" required
                        class="w-full border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500">
                    <p class="text-sm text-gray-500 mt-1">
                        Expected columns: <span class="font-semibold">S/NO, ARMY NO., RANK, FULL NAMES, SEX, 22CR</span>
                    </p>
                </div>

                {{-- Buttons --}}
                <div class="flex items-center space-x-4">
                    <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white font-medium px-5 py-2 rounded-lg transition">
                        Import
                    </button>
                    <a href="{{ route('cr.mark') }}"
                        class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium px-5 py-2 rounded-lg transition">
                        Cancel
                    </a>
                </div>
            </form>

            {{-- Sample Excel Format --}}
            <div class="mt-8">
                <h5 class="text-lg font-semibold text-gray-700 mb-3">Sample Excel Format:</h5>

                <div class="overflow-x-auto">
                    <table class="min-w-full border border-gray-300 text-sm text-left text-gray-700">
                        <thead class="bg-gray-100 text-gray-800">
                            <tr class="bg-gray-50">
                                <th class="px-4 py-2 border">S/NO</th>
                                <th class="px-4 py-2 border">ARMY NO.</th>
                                <th class="px-4 py-2 border">RANK</th>
                                <th class="px-4 py-2 border">FULL NAMES</th>
                                <th class="px-4 py-2 border">SEX</th>
                                <th class="px-4 py-2 border">22CR</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="px-4 py-2 border">1</td>
                                <td class="px-4 py-2 border">RA/12345</td>
                                <td class="px-4 py-2 border">Pte</td>
                                <td class="px-4 py-2 border">John Doe</td>
                                <td class="px-4 py-2 border">M</td>
                                <td class="px-4 py-2 border">85.5</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
