@extends('layouts.app')

@section('title', 'Mark CR Assessments')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="bg-white rounded-lg shadow-md">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-800">CR Assessment Marking</h3>
                @php
                    $activePhase = \App\Models\Phase::where('is_active', 1)->first();
                @endphp
                @if($activePhase)
                    <span class="text-sm font-medium text-blue-600 bg-blue-50 px-3 py-1 rounded-full">
                        Current Phase: {{ $activePhase->name }}
                    </span>
                @endif
            </div>
            
            <!-- Warning Alert -->
            <div class="mt-3 bg-yellow-50 border border-yellow-200 rounded-md p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-yellow-800">
                            Important Notice
                        </h3>
                        <div class="mt-2 text-sm text-yellow-700">
                            <p>
                                <strong>WARNING:</strong> Anyone entering these records MUST confirm that the current phase "{{ $activePhase->name ?? 'N/A' }}" has no existing marks for the current phase records. 
                                Ensure you are marking the correct phase to avoid data duplication.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Phase Selection Form -->
            <div class="mt-4 bg-gray-50 rounded-lg p-4">
                <form method="GET" action="{{ route('cr.mark') }}" class="flex items-end space-x-4">
                    <div class="flex-1">
                        <label for="phase" class="block text-sm font-medium text-gray-700 mb-1">
                            Select Phase to Mark:
                        </label>
                        <select name="phase" id="phase" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @php
                                $phases = \App\Models\Phase::all();
                                $selectedPhase = request('phase', $selectedPhaseId ?? null);
                            @endphp
                            @foreach($phases as $phaseOption)
                                <option value="{{ $phaseOption->id }}" {{ $selectedPhase == $phaseOption->id ? 'selected' : '' }}>
                                    {{ $phaseOption->name }} 
                                    @if($phaseOption->is_active)
                                        (Active)
                                    @endif
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors">
                            Load Phase
                        </button>
                    </div>
                    @if($selectedPhase)
                        <div class="text-sm text-gray-600">
                            <span class="font-medium">Selected:</span> 
                            {{ $phases->firstWhere('id', $selectedPhase)->name ?? 'Unknown Phase' }}
                        </div>
                    @endif
                </form>
            </div>
        </div>

        <!-- Filters Section -->
        <div class="p-6">
            <form method="GET" action="{{ route('cr.mark') }}" class="mb-6">
                <input type="hidden" name="phase" value="{{ $selectedPhaseId }}">
                <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                    <div>
                        <label for="bn" class="block text-sm font-medium text-gray-700 mb-1">Filter by Battalion (BN):</label>
                        <select name="bn" id="bn" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Battalions</option>
                            @foreach($bns ?? [] as $bn)
                                <option value="{{ $bn }}" {{ request('bn') == $bn ? 'selected' : '' }}>{{ $bn }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="coy" class="block text-sm font-medium text-gray-700 mb-1">Filter by Company (COY):</label>
                        <select name="coy" id="coy" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Companies</option>
                            @foreach($coys ?? [] as $coy)
                                <option value="{{ $coy }}" {{ request('coy') == $coy ? 'selected' : '' }}>{{ $coy }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="pl" class="block text-sm font-medium text-gray-700 mb-1">Filter by Platoon (PL):</label>
                        <select name="pl" id="pl" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Platoons</option>
                            @foreach($pls ?? [] as $pl)
                                <option value="{{ $pl }}" {{ request('pl') == $pl ? 'selected' : '' }}>{{ $pl }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="sec" class="block text-sm font-medium text-gray-700 mb-1">Filter by Section (SEC):</label>
                        <select name="sec" id="sec" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Sections</option>
                            @foreach($secs ?? [] as $sec)
                                <option value="{{ $sec }}" {{ request('sec') == $sec ? 'selected' : '' }}>{{ $sec }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="marked" class="block text-sm font-medium text-gray-700 mb-1">Marked Status:</label>
                        <select name="marked" id="marked" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All</option>
                            <option value="1" {{ request('marked') == '1' ? 'selected' : '' }}>Marked</option>
                            <option value="0" {{ request('marked') == '0' ? 'selected' : '' }}>Not Marked</option>
                        </select>
                    </div>
                </div>
                <div class="mt-4 flex space-x-3">
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors">
                        Apply Filters
                    </button>
                    <a href="{{ route('cr.mark') }}?phase={{ $selectedPhaseId }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition-colors">
                        Reset Filters
                    </a>
                </div>
            </form>

            @if(session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    {{ session('success') }}
                </div>
            @endif

            <!-- CR Marking Form -->
            <form method="POST" action="{{ route('cr.update') }}">
                @csrf
                <input type="hidden" name="phase_id" value="{{ $selectedPhaseId }}">
                
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-200">
                        <thead class="bg-gray-800 text-white">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">S/No</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Army No</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Rank</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Full Name</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Sex</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Score</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Remarks</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Marked</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Marked By</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @forelse($admissions as $index => $admission)
                                @php
                                    $existingCR = $existingCRs[$admission->id] ?? null;
                                    $currentScore = $existingCR ? $existingCR->score : 0;
                                    $isMarked = $existingCR ? true : false;
                                    $markedBy = $existingCR ? $existingCR->marked_by : null;
                                @endphp
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $index + 1 }}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->army_number }}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->rank }}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->name }}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->sex ?? 'N/A' }}</td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                               <input type="number" 
       name="scores[{{ $admission->id }}][score]" 
       value="{{ $currentScore }}" 
       min="0" 
       max="15" 
       step="0.1"
       class="w-20 border border-gray-300 rounded px-2 py-1 text-center focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 score-input" 
       onchange="updateRemarks(this)">

                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <span class="remarks text-sm font-semibold px-2 py-1 rounded" id="remarks-{{ $admission->id }}">
                                            @php
                                                echo calculateRemarks($currentScore);
                                            @endphp
                                        </span>
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        @if($isMarked)
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Yes</span>
                                        @else
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">No</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">
                                        {{ $markedBy ?? 'Not Marked' }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="px-4 py-4 text-center text-sm text-gray-500">No records found matching your criteria.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($admissions->count() > 0)
                    <div class="mt-6 flex items-center">
                        <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 transition-colors">
                            Save All CR Scores
                        </button>
                        <span class="ml-3 text-sm text-gray-500">Scores will be saved to CR Assessments table</span>
                    </div>
                @endif
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function calculateRemarks(score) {
    if (!score) return '';
    
    const numericScore = parseFloat(score);
    if (numericScore >= 97.2) return '9.72 - EXCELLENT';
    if (numericScore >= 90) return '9.0+ - VERY GOOD';
    if (numericScore >= 80) return '8.0+ - GOOD';
    if (numericScore >= 70) return '7.0+ - AVERAGE';
    if (numericScore >= 60) return '6.0+ - BELOW AVERAGE';
    return 'FAIL';
}

function updateRemarks(input) {
    const score = input.value;
    const admissionId = input.name.match(/\d+/)[0];
    const remarksElement = document.getElementById('remarks-' + admissionId);
    
    remarksElement.textContent = calculateRemarks(score);
}

// Initialize remarks on page load
document.addEventListener('DOMContentLoaded', function() {
    const scoreInputs = document.querySelectorAll('.score-input');
    scoreInputs.forEach(input => {
        updateRemarks(input);
    });
});
</script>
@endpush

@php
function calculateRemarks($score) {
    if (!$score) return '';

    $numericScore = floatval($score);
    
    if ($numericScore >= 97.2) return '9.72 - EXCELLENT';
    if ($numericScore >= 90) return '9.0+ - VERY GOOD';
    if ($numericScore >= 80) return '8.0+ - GOOD';
    if ($numericScore >= 70) return '7.0+ - AVERAGE';
    if ($numericScore >= 60) return '6.0+ - BELOW AVERAGE';
    return 'FAIL';
}
@endphp

<style>
.remarks {
    font-weight: bold;
}
</style>