@extends('layouts.app')

@section('title', '22 CR Overview')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="bg-white rounded-lg shadow-md">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-800">22 CR Overview</h3>
            <p class="text-sm text-gray-600 mt-1">View and filter cadet performance by school, course, battalion, company, and platoon.</p>
        </div>

        <!-- Filters Section -->
        <div class="p-6">
            <form method="GET" action="{{ route('cr.overview') }}" class="mb-6">
                <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-6 gap-4 mb-4">
                    <div>
                        <label for="school" class="block text-sm font-medium text-gray-700 mb-1">School</label>
                        <select name="school" id="school" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Schools</option>
                            @foreach($schools ?? [] as $school)
                                <option value="{{ $school }}" {{ request('school') == $school ? 'selected' : '' }}>{{ $school }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="course" class="block text-sm font-medium text-gray-700 mb-1">Course</label>
                        <select name="course" id="course" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Courses</option>
                            @foreach($courses ?? [] as $course)
                                <option value="{{ $course }}" {{ request('course') == $course ? 'selected' : '' }}>{{ $course }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="bn" class="block text-sm font-medium text-gray-700 mb-1">Battalion</label>
                        <select name="bn" id="bn" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Battalions</option>
                            @foreach($bns ?? [] as $bn)
                                <option value="{{ $bn }}" {{ request('bn') == $bn ? 'selected' : '' }}>{{ $bn }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="coy" class="block text-sm font-medium text-gray-700 mb-1">Company</label>
                        <select name="coy" id="coy" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Companies</option>
                            @foreach($coys ?? [] as $coy)
                                <option value="{{ $coy }}" {{ request('coy') == $coy ? 'selected' : '' }}>{{ $coy }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="pl" class="block text-sm font-medium text-gray-700 mb-1">Platoon</label>
                        <select name="pl" id="pl" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Platoons</option>
                            @foreach($pls ?? [] as $pl)
                                <option value="{{ $pl }}" {{ request('pl') == $pl ? 'selected' : '' }}>{{ $pl }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label for="sort" class="block text-sm font-medium text-gray-700 mb-1">Sort Direction</label>
                        <select name="sort" id="sort" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="default" {{ request('sort') == 'default' ? 'selected' : '' }}>Default</option>
                            <option value="score_asc" {{ request('sort') == 'score_asc' ? 'selected' : '' }}>Score (Low to High)</option>
                            <option value="score_desc" {{ request('sort') == 'score_desc' ? 'selected' : '' }}>Score (High to Low)</option>
                            <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>Name (A-Z)</option>
                            <option value="name_desc" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>Name (Z-A)</option>
                        </select>
                    </div>
                </div>
                
                <div class="flex space-x-3">
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors">
                        Apply Filters
                    </button>
                    <a href="{{ route('cr.overview') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition-colors">
                        Reset Filters
                    </a>
                    <a href="{{ route('cr.mark') }}?{{ http_build_query(request()->query()) }}" 
                       class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 transition-colors">
                        Add cr Marks
                    </a>
             <a href="{{ route('cr.import.form') }}?{{ http_build_query(request()->query()) }}" 
                       class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 transition-colors">
                       Import cr Marks
                    </a>
{{-- cr.import.form --}}


                </div>
            </form>

            <!-- Results Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border border-gray-200">
                    <thead class="bg-gray-800 text-white">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">SN</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Army Number</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Rank</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Cadet Name</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Phase</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">22CR Score</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Remarks</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse($assessments as $index => $assessment)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $index + 1 }}</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $assessment->army_number }}</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $assessment->rank }}</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $assessment->name }}</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $assessment->phase->name ?? 'N/A' }}</td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700 font-semibold">
                                    {{ $assessment->score ? number_format($assessment->score, 2) . '% /15%' : 'N/A' }}
                                </td>
                         <td class="px-4 py-3 whitespace-nowrap">
    <span
        class="text-sm font-semibold px-2 py-1 rounded
            {{ $assessment->score >= 8 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
        {{ $assessment->score !== null ? ($assessment->score >= 8 ? 'PASS' : 'FAIL') : 'NOT MARKED' }}
    </span>
</td>

                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-4 py-4 text-center text-sm text-gray-500">
                                    No CR assessment records found matching your criteria.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($assessments->count() > 0)
                <div class="mt-4 text-sm text-gray-600">
                    Showing {{ $assessments->count() }} record(s)
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@php
function calculateRemarks($score) {
    if (!$score) return '';

    $numericScore = floatval($score);
    
    if ($numericScore >= 97.2) return '9.72 - EXCELLENT';
    if ($numericScore >= 90) return '9.0+ - VERY GOOD';
    if ($numericScore >= 80) return '8.0+ - GOOD';
    if ($numericScore >= 70) return '7.0+ - AVERAGE';
    if ($numericScore >= 60) return '6.0+ - BELOW AVERAGE';
    return 'FAIL';
}
@endphp