@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 py-6">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">STRART Overview</h1>
            <p class="text-gray-600">View the latest STRART statistics, including total cadets, schools, subjects, exercises, pass rate, average score, assessments for today, <br> improvement rate, and more...</p>
        </div>
    </div>
@if($warning)
    @if($warning['type'] === 'error')
    <div class="p-6 mb-6 bg-red-100 border-l-4 border-red-600 text-red-800 rounded-lg shadow-lg animate-pulse">
        <div class="flex items-center mb-3">
            <svg class="w-8 h-8 mr-3 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
            </svg>
            <div>
                <h3 class="text-xl font-bold text-red-800">{{ $warning['title'] }}</h3>
                <p class="text-red-700">{{ $warning['message'] }}</p>
            </div>
        </div>
        
        <div class="mt-4 p-4 bg-red-50 rounded border border-red-200">
            <p class="text-sm text-red-800 mb-3">
                <span class="font-bold">⚠️ CRITICAL:</span> STRART requires cadet records to function properly. 
                You cannot access assessment features, generate reports, or track performance without adding cadets first.
            </p>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div class="bg-white p-3 rounded shadow-sm">
                    <h4 class="font-semibold text-gray-700 mb-2">Unavailable Features:</h4>
                    <ul class="text-sm text-gray-600 list-disc pl-5 space-y-1">
                        <li>Assessment entry and tracking</li>
                        <li>Performance reports</li>
                        <li>Cadet performance analytics</li>
                        <li>Company/Battalion comparisons</li>
                        <li>Exercise participation tracking</li>
                    </ul>
                </div>
                
                <div class="bg-yellow-50 p-3 rounded shadow-sm">
                    <h4 class="font-semibold text-yellow-800 mb-2">Next Steps:</h4>
                    <ol class="text-sm text-yellow-800 list-decimal pl-5 space-y-1">
                        <li>Click the button below to add cadets</li>
                        <li>Add basic cadet information (name, army number)</li>
                        <li>Assign cadets to companies/platoons</li>
                        <li>Return to dashboard to access all features</li>
                    </ol>
                </div>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-3">
                <a href="{{ route('admissions.index') }}" 
                   class="inline-flex items-center justify-center px-6 py-3 bg-red-600 hover:bg-red-700 text-white font-bold rounded-lg shadow-md transition-colors duration-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    ADD CADETS NOW
                </a>
                
       
            </div>
            
            <div class="mt-4 text-xs text-gray-500 border-t pt-3">
                <p>Need help? Contact support or check the user manual for batch import templates.</p>
            </div>
        </div>
    </div>
    
    @elseif($warning['type'] === 'warning')
    <div class="p-4 mb-4 bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 rounded">
        <div class="flex items-start">
            <svg class="w-6 h-6 mr-2 flex-shrink-0 text-yellow-500" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10c0 4.418-3.582 8-8 8s-8-3.582-8-8 3.582-8 8-8 8 3.582 8 8zm-8 4a1 1 0 100-2 1 1 0 000 2zm0-6a1 1 0 00-.993.883L9 9v3a1 1 0 001.993.117L11 12V9a1 1 0 00-1-1z" clip-rule="evenodd" />
            </svg>
            <div>
                <strong class="block">{{ $warning['title'] }}</strong>
                <p>{{ $warning['message'] }}</p>
            </div>
        </div>
        <div class="mt-3 ml-8">
            <a href="{{ $warning['link'] }}" class="inline-block bg-yellow-500 hover:bg-yellow-600 text-white font-semibold py-2 px-4 rounded transition-colors duration-200">
                {{ $warning['linkText'] }}
            </a>
        </div>
    </div>
    @endif
@endif
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

        
        <!-- Header -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
 
            <div class="flex justify-between items-center">
                <h1 class="text-3xl font-bold text-gray-900">       @php
            $phase = \App\Models\Phase::where('is_active', 1)->first();
        @endphp
        @if($phase)
            <span class="text-sm font-medium text-blue-600 bg-blue-50 px-3 py-1 rounded-full">
                Current Phase: {{ $phase->name }}
            </span>
        @endif</h1>

                <div class="text-sm text-gray-500">Last updated: {{ now()->format('d M Y, H:i') }}</div>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
            <div class="bg-white rounded-lg shadow-sm p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 bg-opacity-50">
                        <svg class="h-8 w-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h2 class="text-sm font-medium text-gray-600">Total Cadets</h2>
                        <p class="text-2xl font-bold text-gray-900">{{ $totalCadets }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-sm p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 bg-opacity-50">
                        <svg class="h-8 w-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>



                    <div class="ml-4">
                        <h2 class="text-sm font-medium text-gray-600">Total Schools</h2>
                        <p class="text-2xl font-bold text-gray-900">{{ $totalSchools }}</p>
                    </div>
                </div>
            </div>


            <div class="bg-white rounded-lg shadow-sm p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 bg-opacity-50">
                        <svg class="h-8 w-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h2 class="text-sm font-medium text-gray-600">Total Subjects</h2>
                        <p class="text-2xl font-bold text-gray-900">{{  $totalsubjects }}</p>
                    </div>
                </div>
            </div>


            <div class="bg-white rounded-lg shadow-sm p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 bg-opacity-50">
                        <svg class="h-8 w-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h2 class="text-sm font-medium text-gray-600">Total Exercises</h2>
                        <p class="text-2xl font-bold text-gray-900">{{ $exercises }}</p>
                    </div>
                </div>
            </div>

            {{-- exercises --}}
        </div>

        <!-- Performance Metrics -->
<div class="mt-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
    <div class="bg-white rounded-lg shadow-sm p-4">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm font-medium text-gray-600">Pass Rate</p>
                <p class="text-2xl font-bold text-gray-900">{{ number_format($metrics['passRate'] ?? 0, 1) }}%</p>
            </div>
            <div class="p-3 rounded-full {{ ($metrics['passRate'] ?? 0) >= 50 ? 'bg-green-100 text-green-600' : 'bg-red-100 text-red-600' }}">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                </svg>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-4">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm font-medium text-gray-600">Average Score</p>
                <p class="text-2xl font-bold text-gray-900">{{ number_format($metrics['averageScore'] ?? 0, 1) }}%</p>
            </div>
            <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-4">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm font-medium text-gray-600">Assessments Today</p>
                <p class="text-2xl font-bold text-gray-900">{{ $metrics['todayAssessments'] ?? 0 }}</p>
            </div>
            <div class="p-3 rounded-full bg-yellow-100 text-yellow-600">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-4">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm font-medium text-gray-600">Improvement Rate</p>
                <p class="text-2xl font-bold text-gray-900">{{ number_format($metrics['improvementRate'] ?? 0, 1) }}%</p>
            </div>
            <div class="p-3 rounded-full bg-indigo-100 text-indigo-600">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                </svg>
            </div>
        </div>
    </div>
</div>
<!-- Best of the Best Section -->
<div class="mt-6">
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="px-4 py-3 bg-gradient-to-r from-yellow-600 to-yellow-700">
            <h3 class="text-lg font-semibold text-white flex items-center">
                <svg class="w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                </svg>
                Best of the Best Performers (Overall GPV)
            </h3>
        </div>
        <div class="p-4">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($bestOfBest as $index => $performer)
                    <div class="p-4 rounded-lg {{ $index < 3 ? 'bg-yellow-50 border-2 border-yellow-200' : 'bg-gray-50' }}">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center">
                                    @if($index < 3)
                                        <span class="flex items-center justify-center w-6 h-6 rounded-full {{ $index === 0 ? 'bg-yellow-400' : ($index === 1 ? 'bg-gray-300' : 'bg-yellow-600') }} text-white text-sm font-bold mr-2">
                                            {{ $index + 1 }}
                                        </span>
                                    @endif
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">{{ $performer->name }}</p>
                                        <p class="text-xs text-gray-600">{{ $performer->army_number }}</p>
                                    </div>
                                </div>

                                <div class="mt-2 space-y-1">
                                    <!-- Component Scores -->
                                    <div class="flex justify-between text-xs">
                                        <span class="text-gray-600">Theory:</span>
                                        <span class="font-medium">{{ number_format($performer->theory_score, 1) }}</span>
                                    </div>
                                    <div class="flex justify-between text-xs">
                                        <span class="text-gray-600">Practical:</span>
                                        <span class="font-medium">{{ number_format($performer->practical_score, 1) }}</span>
                                    </div>
                                    <div class="flex justify-between text-xs">
                                        <span class="text-gray-600">22CR:</span>
                                        <span class="font-medium">{{ number_format($performer->cr22_score, 1) }}</span>
                                    </div>
                                    <div class="flex justify-between text-xs">
                                        <span class="text-gray-600">PR:</span>
                                        <span class="font-medium">{{ number_format($performer->pr_score, 1) }}</span>
                                    </div>
                                    
                                    <div class="border-t pt-1 mt-1">
                                        <div class="flex justify-between text-xs font-semibold">
                                            <span class="text-gray-700">Total:</span>
                                            <span class="text-gray-900">{{ number_format($performer->total_score, 1) }}</span>
                                        </div>
                                    </div>

                                    <!-- Unit Information -->
                                    <p class="text-xs text-gray-500 mt-2">
                                        {{ $performer->bn }} Bn | {{ $performer->coy }} Coy | {{ $performer->pl }} Pl
                                    </p>
                                    
                                    <!-- Grade and Comment -->
                                    <div class="flex justify-between items-center mt-2">
                                        <span class="px-2 py-1 text-xs font-semibold bg-blue-100 text-blue-800 rounded">
                                            Grade: {{ $performer->grade }}
                                        </span>
                                        <span class="text-xs text-gray-600">{{ $performer->comment }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="ml-4">
                                <span class="px-3 py-1 text-sm font-semibold {{ $index < 3 ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800' }} rounded-full">
                                    {{ number_format($performer->marks, 1) }}%
                                </span>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            
            @if(count($bestOfBest) === 0)
                <div class="text-center py-8 text-gray-500">
                    <svg class="w-12 h-12 mx-auto mb-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                    </svg>
                    <p>No performance data available for the current phase.</p>
                </div>
            @endif
        </div>
    </div>
</div>


<div class="mt-6">
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="px-4 py-3 bg-gradient-to-r from-indigo-600 to-indigo-700">
            <h3 class="text-lg font-semibold text-white flex items-center">
                <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                </svg>
                Best Pls Overall
            </h3>
        </div>
        <div class="p-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @foreach($bestPlatoons as $index => $platoon)
                    <div class="p-4 {{ $index < 3 ? 'bg-indigo-50 border-2 border-indigo-200' : 'bg-gray-50' }} rounded-lg">
                        <div class="flex justify-between items-start mb-2">
                            <div>
                                <div class="flex items-center">
                                    @if($index < 3)
                                        <span class="flex items-center justify-center w-6 h-6 rounded-full {{ $index === 0 ? 'bg-indigo-400' : ($index === 1 ? 'bg-indigo-300' : 'bg-indigo-200') }} text-white text-sm font-bold mr-2">
                                            {{ $index + 1 }}
                                        </span>
                                    @endif
                                    <h4 class="text-lg font-semibold">{{ $platoon['pl'] }} Pl</h4>
                                </div>
{{--                                <p class="text-sm text-gray-600">{{ $platoon['total_cadets'] }} Cadets</p>--}}
                            </div>
                            <span class="px-3 py-1 text-sm font-semibold bg-indigo-100 text-indigo-800 rounded-full">
                                {{ number_format($platoon['average_marks'], 1) }}%
                            </span>
                        </div>

                        <div class="space-y-2">
                            @foreach($platoon['performance_by_type'] as $type => $performance)
                                <div>
                                    <div class="flex justify-between text-xs mb-1">
                                        <span class="text-gray-600">{{ $type }}</span>
                                        <span class="text-gray-900">{{ number_format($performance['average'], 1) }}%</span>
                                    </div>
                                    <div class="h-1.5 bg-gray-200 rounded-full overflow-hidden">
                                        <div class="h-full bg-indigo-500 rounded-full"
                                             style="width: {{ $performance['average'] }}%">
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
        <!-- filepath: /c:/xampp/htdocs/army_project2/resources/views/dashboard.blade.php -->

<!-- Subject-wise Performance -->


<div class="mt-6 grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Performance Overview Card -->
    {{-- <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="px-4 py-2 bg-gradient-to-r from-green-600 to-green-700">
            <h3 class="text-sm font-semibold text-white">Performance Overview</h3>
        </div>
        <div class="p-4">
            <canvas id="performanceChart" height="200"></canvas>
        </div>
    </div> --}}

    <!-- Recent Assessments -->
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700">
            <h3 class="text-sm font-semibold text-white">Recent Assessments</h3>
        </div>
        <div class="p-4">
            <div class="space-y-4">
                @foreach($recentAssessments ?? [] as $assessment)
                    <div class="flex items-center space-x-4">
                        <div class="flex-shrink-0">
                            <span class="inline-flex items-center justify-center h-8 w-8 rounded-full {{ $assessment->marks >= 50 ? 'bg-green-100 text-green-600' : 'bg-red-100 text-red-600' }}">
                                {{ number_format($assessment->marks) }}%
                            </span>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 truncate">
                                {{ $assessment->admission->name  ?? 'N/A' }}
                            </p>
                            <p class="text-xs text-gray-500">
                                {{ $assessment->subject->name ?? $assessment->exercises }} |
                                {{ $assessment->type }}
                            </p>
                        </div>
                        <div class="text-xs text-gray-500">
                            {{ $assessment->created_at->diffForHumans() }}
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Assessment Distribution -->
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="px-4 py-2 bg-gradient-to-r from-purple-600 to-purple-700">
            <h3 class="text-sm font-semibold text-white">Assessment Distribution</h3>
        </div>
        <div class="p-4">
            <canvas id="distributionChart" height="200"></canvas>
        </div>
    </div>
</div>



<!-- filepath: /c:/xampp/htdocs/army_project2/resources/views/dashbaord.blade.php -->

<!-- Top Performers by Assessment Type -->
<div class="mt-6 grid grid-cols-1 lg:grid-cols-3 gap-6">
    @foreach($topPerformersByType as $type => $performers)
        <div class="bg-white rounded-lg shadow-sm overflow-hidden">
            <div class="px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700">
                <h3 class="text-sm font-semibold text-white">Top {{ $type }} Performers</h3>
            </div>
            <div class="p-4">
                @foreach($performers as $performer)
                    <div class="mb-3 p-3 bg-gray-50 rounded-lg">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ $performer->name }}</p>
                                <p class="text-xs text-gray-600">
                                    {{ $performer->army_number }} |
                                    {{ $performer->assessment_group }} |
                                    Week {{ substr($performer->week, -1) }}
                                </p>
                            </div>
                            <span class="px-2 py-1 text-xs {{ $performer->marks >= 50 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }} rounded-full">
                                {{ number_format($performer->marks, 1) }}%
                            </span>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endforeach
</div>

        <div class="mt-6 grid grid-cols-1 lg:grid-cols-3 gap-6">
            @foreach($topPerformersByTypes as $type => $performers)
                <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                    <div class="px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700">
                        <h3 class="text-sm font-semibold text-white">Top {{ $type }} Performers</h3>
                    </div>
                    <div class="p-4">
                        @foreach($performers as $performer)
                            <div class="mb-3 p-3 bg-gray-50 rounded-lg">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">{{ $performer['name'] }}</p>
                                        <p class="text-xs text-gray-600">
                                            {{ $performer['army_number'] }}
                                        </p>
                                    </div>

                                    @if( $type == "22CR")

                                        <span class="inline-flex items-center justify-center h-8 w-8 rounded-full {{ $performer['score'] >= 10 ? 'bg-green-100 text-green-600' : 'bg-red-100 text-red-600' }}">
                                {{ number_format($performer['score'], 1) }}
                            </span>
                                    @endif

                                    @if( $type == "PR")

                                        <span class="inline-flex items-center justify-center h-8 w-8 rounded-full {{ $performer['score'] >= 3 ? 'bg-green-100 text-green-600' : 'bg-red-100 text-red-600' }}">
                                {{ number_format($performer['score'], 1) }}
                            </span>
                                        @endif

{{--                                {{ number_format($performer['score'], 1) }}%--}}
                            </span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>


<div class="mt-6">
    <h3 class="text-lg font-semibold mb-4">Top Performers by Subject</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($topPerformersBySubject as $subject => $performers)
            <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                <div class="px-4 py-2 bg-gradient-to-r from-green-600 to-green-700">
                    <h3 class="text-sm font-semibold text-white">{{ $subject }}</h3>
                </div>
                <div class="p-4">
                    @foreach($performers as $performer)
                        <div class="mb-2">
                            <div class="flex justify-between items-center">
                                <span class="text-sm font-medium">{{ $performer->name }}</span>
                                <span class="text-sm {{ $performer->marks >= 50 ? 'text-green-600' : 'text-red-600' }}">
                                    {{ number_format($performer->marks, 1) }}%
                                </span>
                            </div>
                            <p class="text-xs text-gray-500">{{ $performer->army_number }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
</div>

<!-- Exercise Performance -->
<div class="mt-6">
    <h3 class="text-lg font-semibold mb-4">Exercise Performance</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($topPerformersByExercise as $exercise => $data)
            <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                <div class="px-4 py-2 bg-gradient-to-r from-green-600 to-green-700">
                    <h3 class="text-sm font-semibold text-white">{{ $data['exercise_name'] }}</h3>
                </div>
                <div class="p-4">
                    <div class="space-y-3">
                        @foreach($data['performers'] as $performer)
                            <div class="p-3 bg-gray-50 rounded-lg">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">
                                            {{ $performer->name }}
                                        </p>
                                        <p class="text-xs text-gray-600">
                                            {{ $performer->army_number }} |
                                            {{ $performer->bn }} Bn |
                                            {{ $performer->coy }} Coy
                                        </p>
                                        <p class="text-xs text-gray-500">
                                            Week {{ substr($performer->week, -1) }} |
                                            {{ $performer->assessment_group }}
                                        </p>
                                    </div>
                                    <span class="px-2 py-1 text-xs {{ $performer->marks >= 50 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }} rounded-full">
                                        {{ number_format($performer->marks, 1) }}%
                                    </span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
</div>

@endsection

@push('styles')
<style>
<style>
    .bg-gradient-to-r {
        background-size: 200% 200%;
        animation: gradient 15s ease infinite;
    }

    @keyframes gradient {
        0% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
        100% { background-position: 0% 50%; }
    }

    .progress-bar {
        transition: width 1s ease-in-out;
    }

    .card-hover {
        transition: transform 0.2s ease-in-out;
    }

    .card-hover:hover {
        transform: translateY(-2px);
    }

    .metric-value {
        font-feature-settings: "tnum";
        font-variant-numeric: tabular-nums;
    }00% { background-position: 0% 50%; }

</style>
@push('scripts')

<script src="{{ asset('js/chart.js') }}"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Performance Chart
    const perfCtx = document.getElementById('performanceChart').getContext('2d');
    new Chart(perfCtx, {
        type: 'line',
        data: {
            labels: {!! json_encode($chartData['labels'] ?? []) !!},
            datasets: [{
                label: 'Average Performance',
                data: {!! json_encode($chartData['performance'] ?? []) !!},
                borderColor: '#10B981',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });

    // Distribution Chart
    const distCtx = document.getElementById('distributionChart').getContext('2d');
    new Chart(distCtx, {
        type: 'doughnut',
        data: {
            labels: ['Excellent', 'Good', 'Average', 'Need Improvement'],
            datasets: [{
                data: {!! json_encode($chartData['distribution'] ?? [25, 30, 25, 20]) !!},
                backgroundColor: ['#10B981', '#3B82F6', '#F59E0B', '#EF4444']
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
});
</script>
@endpush
