@extends('layouts.app')
@section('title', 'Edit Exam Weight ')
@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Exam Weight Record</h2>

    <form action="{{ route('examweight.update', $record->id) }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf
        @method('PUT')
        <div class="mb-4">
            <label for="name" class="block text-gray-700 font-semibold mb-2">Title</label>
            <input type="text" name="name" id="name" value="{{ $record->name }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>

        <div class="mb-4">
            <label for="phase_id" class="block text-gray-700 font-semibold mb-2">Select Phase</label>
            <select name="phase_id" id="phase_id" class="w-full p-3 border border-gray-300 rounded" required>
                <option value="">Choose a Phase</option>
                @foreach($phases as $id => $name)
                    <option value="{{ $id }}" {{ old('phase', $record->phase_id) == $id ? 'selected' : '' }}>
                        {{ $name }}
                    </option>
                @endforeach
            </select>
        </div>




        <div class="mb-4">
            <label for="weight" class="block text-gray-700 font-semibold mb-2">Weight</label>
            <input type="number" step="0.01" name="weight" id="weight" value="{{ $record->weight }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>



        <div class="flex gap-4">
            <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Update Record</button>
            <a href="{{ route('exercise.index') }}" class="bg-gray-500 text-white px-6 py-3 rounded hover:bg-gray-600">Cancel</a>
        </div>
    </form>
</div>
@endsection
