@extends('layouts.app')
@section('title', 'Create Exercise')
@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Create Exercise New Record</h2>

    <form action="{{ route('exercise.store') }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf


        <div class="mb-4">
            <label for="phase_id" class="block text-gray-700 font-semibold mb-2">Select Phase</label>
            <select name="phase_id" id="phase_id" class="w-full p-3 border border-gray-300 rounded" required>
                <option value="">Choose a Phase</option>
                @foreach($phases as $phase)
                    <option value="{{ $phase->id }}">{{ $phase->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-4">
            <label for="title" class="block text-gray-700 font-semibold mb-2">Name</label>
            <input type="text" name="title" id="title" class="w-full p-3 border border-gray-300 rounded" required>
        </div>

        <div class="mb-4">
            <label for="weight" class="block text-gray-700 font-semibold mb-2">Weight</label>
            <input type="number" step="0.01" name="weight" id="weight" class="w-full p-3 border border-gray-300 rounded" required>
        </div>



        <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Create Record</button>
    </form>
</div>
@endsection
