<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admissions Report</title>
    <style>
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid black; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Admissions Report</h2>
    <table>
        <thead>
            <tr>
                <th>Admission ID</th>
                <th>Army Number</th>
                <th>Rank</th>
                <th>Name</th>
                <th>School</th>
                <th>Course</th>
            </tr>
        </thead>
        <tbody>
            @foreach($admissions as $admission)
            <tr>
                <td>{{ $admission->admission_id }}</td>
                <td>{{ $admission->army_number }}</td>
                <td>{{ $admission->rank }}</td>
                <td>{{ $admission->name }}</td>
                <td>{{ $admission->school->name }}</td>
                <td>{{ $admission->course->name }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
