<!-- resources/views/exports/assessments_pdf.blade.php -->
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Assessment Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .filters {
            margin-bottom: 15px;
            font-size: 11px;
        }
        .filter-item {
            display: inline-block;
            margin-right: 15px;
            margin-bottom: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
            text-align: center;
            padding: 5px;
            font-size: 11px;
        }
        td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: center;
            font-size: 10px;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .monthly-header {
            background-color: #2196F3;
        }
        .eope-header {
            background-color: #9C27B0;
        }
        .no-data {
            text-align: center;
            color: #666;
            padding: 20px;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Assessment Report</h2>
    <h3>{{ $type }} Assessment</h3>
</div>

<div class="filters">
    <p><strong>Filters:</strong></p>
    @foreach($filters as $key => $value)
        @if(!empty($value) && $key !== '_token')
            <div class="filter-item">
                <strong>{{ ucwords(str_replace('_', ' ', $key)) }}:</strong> {{ $value }}
            </div>
        @endif
    @endforeach
</div>

<table>
    <thead>
    <tr>
        <th>Army Number</th>
        <th>Rank</th>
        <th>Cadet Name</th>

        @if($type == 'Monthly')
            @foreach($columns as $month)
                <th class="monthly-header">
                    Monthly {{ substr($month, -1) }}
                </th>
            @endforeach
        @elseif($type == 'End of Phase Exam')
            <th class="eope-header">EOPE</th>
        @else
            @for($i = 1; $i <= 10; $i++)
                <th>Week {{ $i }}</th>
            @endfor
        @endif
    </tr>
    </thead>
    <tbody>
    @forelse($assessments as $studentData)
        @php
            $firstAssessment = $studentData->first();
            $assessmentMarks = $studentData->groupBy(function($assessment) {
                if ($assessment->type === 'Monthly') {
                    return 'monthly' . preg_replace('/[^0-9]/', '', $assessment->month, -1);
                } elseif ($assessment->type === 'End of Phase Exam') {
                    return 'eope';
                } else {
                    return preg_replace('/[^0-9]/', '', $assessment->week, -1);
                }
            });
        @endphp

        <tr>
            <td>{{ $firstAssessment->admission->army_number }}</td>
            <td>{{ $firstAssessment->admission->rank }}</td>
            <td>{{ $firstAssessment->admission->name }}</td>

            @if($type == 'Monthly')
                @foreach($columns as $month)
                    @php
                        $monthKey = 'monthly' . substr($month, -1);
                        $assessment = isset($assessmentMarks[$monthKey]) ? $assessmentMarks[$monthKey]->first() : null;
                    @endphp
                    <td>
                        @if($assessment)
                            {{ $assessment->marks }}/{{ $assessment->weight }}
                        @else
                            N/A
                        @endif
                    </td>
                @endforeach
            @elseif($type == 'End of Phase Exam')
                @php
                    $assessment = isset($assessmentMarks['eope']) ? $assessmentMarks['eope']->first() : null;
                @endphp
                <td>
                    @if($assessment)
                        {{ $assessment->marks }}/{{ $assessment->weight }}
                    @else
                        N/A
                    @endif
                </td>
            @else
                @for($week = 1; $week <= 10; $week++)
                    @php
                        $assessment = isset($assessmentMarks[$week]) ? $assessmentMarks[$week]->first() : null;
                    @endphp
                    <td>
                        @if($assessment)
                            {{ $assessment->marks }}/{{ $assessment->weight }}
                        @else
                            N/A
                        @endif
                    </td>
                @endfor
            @endif
        </tr>
    @empty
        <tr>
            <td colspan="{{ $type == 'Monthly' ? count($columns) + 3 : ($type == 'End of Phase Exam' ? 4 : 13) }}" class="no-data">
                No assessments found
            </td>
        </tr>
    @endforelse
    </tbody>
</table>

<div style="margin-top: 20px; font-size: 10px; text-align: right;">
    Generated on {{ date('Y-m-d H:i:s') }}
</div>
</body>
</html>
