<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Marks Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            /*background-color: #f4f7f6;*/
            color: #333;
            margin-top: 3.5cm;
            margin-bottom: 2.5cm;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: #fff;
            padding: 0px;
            margin-top: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        h1 {
            text-align: center;
            color: #1e4b03;
            text-transform: uppercase;
            font-size: 24px;
            margin-bottom: 20px;
        }
        .info-grid p {
            display: inline;
            margin-right: 15px;
        }
        .info-grid .line-break {
            display: block;
            margin-top: 10px;
        }
        table {
            margin-top: 10px;
            width: 100%;
            border-collapse: collapse;

        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #1e4b03;
            color: white;
            text-transform: uppercase;
            font-size: 14px;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        tr:hover {
            background-color: #e1f5fe;
        }
        header {
            position: fixed;
            top: 0cm;
            left: 0cm;
            right: 0cm;
            height: 2cm;

            text-align: center; /* Optional: Center content */
            line-height: 3cm; /* Optional: Vertically center text */
        }

        /* Define the footer rules */
        footer {
            position: fixed;
            bottom: 0cm;
            left: 0cm;
            right: 0cm;
            height: 2cm;

            text-align: center; /* Optional: Center content */
            line-height: 2cm; /* Optional: Vertically center text */
        }


    </style>
</head>
<body>
<header class="site-header">
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</header>



<footer>
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</footer>


<main>

    <div class="container">






        <h1>Marks Report</h1>

        @php
            $firstMark = $groupedMarks->first()->first() ?? null;
        @endphp


        @if($firstMark)
            <div class="info-grid">
                @if(!empty($firstMark->assessment_type))<p><strong>Type:</strong> {{ $firstMark->assessment_type }}</p>@endif
                @if(!empty($firstMark->assessment_group))<p><strong>Group:</strong> {{ $firstMark->assessment_group }}</p>@endif
                @if(!empty($firstMark->type))<p><strong>Exam:</strong> {{ $firstMark->type }}</p>@endif
                @if(!empty($firstMark->month))<p><strong>Month:</strong> {{ $firstMark->month }}</p>@endif
                @if(!empty($firstMark->week))<p><strong>Week:</strong> Week {{ preg_replace('/[^0-9]/', '', $firstMark->week) }}</p>@endif
                <span class="line-break"></span>
                @if(!empty($firstMark->subject->code) || !empty($firstMark->exercises))<p><strong>Subject / Exercise:</strong> {{ $firstMark->subject->code ?? $firstMark->exercises }}</p>@endif
                @if(!empty($firstMark->bn))<p><strong>Bn:</strong> {{ $firstMark->bn }}</p>@endif
                @if(!empty($firstMark->coy))<p><strong>Coy:</strong> {{ $firstMark->coy }}</p>@endif
                @if(!empty($firstMark->pl))<p><strong>Pl:</strong> {{ $firstMark->pl }}</p>@endif
            </div>
        @endif

        <table style="width: 100%; border-collapse: collapse;">
            <thead>
            <tr>
                <th style="padding: 4px; width: 5%;">SN</th>
                <th style="padding: 4px; width: 15%;">Army Number</th>
                <th style="padding: 4px; width: 10%;">Rank</th>
                <th style="padding: 4px; width: 20%;">Names</th>
                <th style="padding: 4px; width: 5%;">Sex</th>
                <th style="padding: 4px; width: 10%;">Marks</th>
                <th style="padding: 4px; width: 10%;">Remarks</th>
            </tr>
            </thead>
            <tbody>
            @php $sn = 1; @endphp
            @foreach($groupedMarks as $key => $marks)
                @php [$armyNumber, $rank, $name, $sex] = explode('|', $key); @endphp
                @foreach($marks as $mark)
                    <tr>
                        <td style="padding: 4px;">{{ $sn++ }}</td>
                        <td style="padding: 4px;">{{ $armyNumber }}</td>
                        <td style="padding: 4px;">{{ $rank }}</td>
                        <td style="padding: 4px;">{{ $name }}</td>
                        <td style="padding: 4px;">{{ $sex }}</td>
                        <td style="padding: 4px;" class="font-bold">{{ $mark->marks }}</td>
                        <td style="padding: 4px;">
                            @if($mark->marks >= 50)
                                <p style="margin: 0;">PASS</p>
                            @else
                                <p style="margin: 0;">Failed</p>
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endforeach
            </tbody>
        </table>



    </div>
</main>

</body>
</html>
