@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto">
        <h2 class="text-2xl font-bold mb-4">Admissions List</h2>
        <button onclick="window.print()" class="bg-blue-500 text-white px-4 py-2 rounded-md">Print</button>
        <table class="min-w-full mt-4 border-collapse border border-gray-300">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">Admission ID</th>
                    <th class="border p-2">Army Number</th>
                    <th class="border p-2">Rank</th>
                    <th class="border p-2">Name</th>
                    <th class="border p-2">School</th>
                    <th class="border p-2">Course</th>
                </tr>
            </thead>
            <tbody>
                @foreach($admissions as $admission)
                <tr>
                    <td class="border p-2">{{ $admission->admission_id }}</td>
                    <td class="border p-2">{{ $admission->army_number }}</td>
                    <td class="border p-2">{{ $admission->rank }}</td>
                    <td class="border p-2">{{ $admission->name }}</td>
                    <td class="border p-2">{{ $admission->school->name }}</td>
                    <td class="border p-2">{{ $admission->course->name }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
